/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.events.publisher;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.pg.common.events.publisher.EventPublisher;
import com.phonepe.sdk.pg.common.events.publisher.QueuedEventPublisher;
import com.phonepe.sdk.pg.common.events.queue.BoundedConcurrentLinkedQueue;
import java.util.Objects;
import okhttp3.OkHttpClient;

public class EventPublisherFactory {
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final String hostUrl;
    private static EventPublisher cachedEventPublisher;

    public EventPublisherFactory(ObjectMapper objectMapper, OkHttpClient okHttpClient, String hostUrl) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.hostUrl = hostUrl;
    }

    public static void setCachedEventPublisher(EventPublisher eventPublisher) {
        cachedEventPublisher = eventPublisher;
    }

    public EventPublisher getEventPublisher(boolean shouldPublishEvents) {
        if (shouldPublishEvents) {
            if (Objects.isNull(cachedEventPublisher)) {
                EventPublisherFactory.setCachedEventPublisher(QueuedEventPublisher.builder().eventQueue(new BoundedConcurrentLinkedQueue(20000)).objectMapper(this.objectMapper).hostUrl(this.hostUrl).okHttpClient(this.okHttpClient).build());
            }
            return cachedEventPublisher;
        }
        return new EventPublisher(){

            @Override
            public void run() {
            }
        };
    }

    public static EventPublisherFactoryBuilder builder() {
        return new EventPublisherFactoryBuilder();
    }

    public static class EventPublisherFactoryBuilder {
        private ObjectMapper objectMapper;
        private OkHttpClient okHttpClient;
        private String hostUrl;

        EventPublisherFactoryBuilder() {
        }

        public EventPublisherFactoryBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public EventPublisherFactoryBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public EventPublisherFactoryBuilder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public EventPublisherFactory build() {
            return new EventPublisherFactory(this.objectMapper, this.okHttpClient, this.hostUrl);
        }

        public String toString() {
            return "EventPublisherFactory.EventPublisherFactoryBuilder(objectMapper=" + String.valueOf(this.objectMapper) + ", okHttpClient=" + String.valueOf(this.okHttpClient) + ", hostUrl=" + this.hostUrl + ")";
        }
    }
}

