/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.events.queue;

import com.phonepe.sdk.pg.common.events.models.BaseEvent;
import com.phonepe.sdk.pg.common.events.queue.EventQueue;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedConcurrentLinkedQueue
implements EventQueue {
    private static final Logger log = LoggerFactory.getLogger(BoundedConcurrentLinkedQueue.class);
    private ConcurrentLinkedQueue<BaseEvent> queue;
    private int maxSize;

    public BoundedConcurrentLinkedQueue(int maxSize) {
        this.queue = new ConcurrentLinkedQueue();
        this.maxSize = maxSize;
    }

    @Override
    public void add(BaseEvent data) {
        if (this.queue.size() < this.maxSize && Objects.nonNull(data)) {
            this.queue.add(data);
        } else {
            log.error("Reached queue max size, skipping event {}", (Object)data.getEventName());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public BaseEvent poll() {
        return this.queue.poll();
    }

    @Override
    public ConcurrentLinkedQueue<BaseEvent> getQueue() {
        return this.queue;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setQueue(ConcurrentLinkedQueue<BaseEvent> queue) {
        this.queue = queue;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundedConcurrentLinkedQueue)) {
            return false;
        }
        BoundedConcurrentLinkedQueue other = (BoundedConcurrentLinkedQueue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        ConcurrentLinkedQueue<BaseEvent> this$queue = this.getQueue();
        ConcurrentLinkedQueue<BaseEvent> other$queue = other.getQueue();
        return !(this$queue == null ? other$queue != null : !this$queue.equals(other$queue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundedConcurrentLinkedQueue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSize();
        ConcurrentLinkedQueue<BaseEvent> $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        return result;
    }

    public String toString() {
        return "BoundedConcurrentLinkedQueue(queue=" + String.valueOf(this.getQueue()) + ", maxSize=" + this.getMaxSize() + ")";
    }

    public BoundedConcurrentLinkedQueue() {
    }
}

