/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.exception;

import com.phonepe.sdk.pg.common.http.PhonePeResponse;
import java.util.Map;

public class PhonePeException
extends RuntimeException {
    private Integer httpStatusCode;
    private String message;
    private transient Map<String, Object> data;
    private String code;

    public PhonePeException(String message) {
        this.message = message;
    }

    public PhonePeException(Integer httpStatusCode, String message) {
        this.httpStatusCode = httpStatusCode;
        this.message = message;
    }

    public PhonePeException(Integer httpStatusCode, String message, PhonePeResponse phonePeResponse) {
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        if (phonePeResponse != null) {
            this.message = phonePeResponse.getMessage() != null ? phonePeResponse.getMessage() : message;
            this.data = phonePeResponse.getData();
            this.code = phonePeResponse.getErrorCode() != null ? phonePeResponse.getErrorCode() : phonePeResponse.getCode();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "\nhttpStatusCode: " + this.httpStatusCode + "\nmessage: " + this.message + "\ndata: " + String.valueOf(this.data) + "\ncode : " + this.code + "\n";
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

