/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.MetaInfo;
import com.phonepe.sdk.pg.common.models.request.DeviceContext;
import com.phonepe.sdk.pg.common.models.request.InstrumentConstraint;
import com.phonepe.sdk.pg.common.models.request.PaymentFlow;
import com.phonepe.sdk.pg.common.models.request.instruments.CardPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.CollectPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.Expiry;
import com.phonepe.sdk.pg.common.models.request.instruments.IntentPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.NetBankingPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.NewCardDetails;
import com.phonepe.sdk.pg.common.models.request.instruments.PhoneNumberCollectPaymentDetails;
import com.phonepe.sdk.pg.common.models.request.instruments.TokenDetails;
import com.phonepe.sdk.pg.common.models.request.instruments.TokenPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.UpiQrPaymentV2Instrument;
import com.phonepe.sdk.pg.common.models.request.instruments.VpaCollectPaymentDetails;
import com.phonepe.sdk.pg.payments.v2.models.request.MerchantUrls;
import com.phonepe.sdk.pg.payments.v2.models.request.PgPaymentFlow;
import com.phonepe.sdk.pg.subscription.v2.models.request.AmountType;
import com.phonepe.sdk.pg.subscription.v2.models.request.AuthWorkflowType;
import com.phonepe.sdk.pg.subscription.v2.models.request.Frequency;
import com.phonepe.sdk.pg.subscription.v2.models.request.RedemptionRetryStrategy;
import com.phonepe.sdk.pg.subscription.v2.models.request.SubscriptionRedemptionPaymentFlow;
import com.phonepe.sdk.pg.subscription.v2.models.request.SubscriptionSetupPaymentFlow;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PgPaymentRequest {
    private String merchantOrderId;
    private Long amount;
    private MetaInfo metaInfo;
    private PaymentFlow paymentFlow;
    private List<InstrumentConstraint> constraints;
    private DeviceContext deviceContext;
    private Long expireAfter;
    private Long expireAt;

    private PgPaymentRequest(String merchantOrderId, Long amount, MetaInfo metaInfo, List<InstrumentConstraint> constraints, Long expireAfter) {
        this.merchantOrderId = merchantOrderId;
        this.amount = amount;
        this.metaInfo = metaInfo;
        this.constraints = constraints;
        this.expireAfter = expireAfter;
    }

    public PgPaymentRequest(String merchantOrderId, long amount, MetaInfo metaInfo, List<InstrumentConstraint> constraints, String deviceOS, String merchantCallBackScheme, String targetApp, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.deviceContext = DeviceContext.builder().deviceOS(deviceOS).merchantCallBackScheme(merchantCallBackScheme).build();
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(IntentPaymentV2Instrument.builder().targetApp(targetApp).build()).build();
    }

    public PgPaymentRequest(long amount, String merchantOrderId, MetaInfo metaInfo, List<InstrumentConstraint> constraints, String vpa, String message, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(CollectPaymentV2Instrument.builder().details(VpaCollectPaymentDetails.builder().vpa(vpa).build()).message(message).build()).build();
    }

    public PgPaymentRequest(long amount, MetaInfo metaInfo, String merchantOrderId, String phoneNumber, List<InstrumentConstraint> constraints, String message, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(CollectPaymentV2Instrument.builder().details(PhoneNumberCollectPaymentDetails.builder().phoneNumber(phoneNumber).build()).message(message).build()).build();
    }

    public PgPaymentRequest(long amount, MetaInfo metaInfo, String merchantOrderId, List<InstrumentConstraint> constraints, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(UpiQrPaymentV2Instrument.builder().build()).build();
    }

    public PgPaymentRequest(long amount, MetaInfo metaInfo, List<InstrumentConstraint> constraints, String merchantOrderId, String bankId, String merchantUserId, String redirectUrl, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(NetBankingPaymentV2Instrument.builder().bankId(bankId).merchantUserId(merchantUserId).build()).merchantUrls(MerchantUrls.builder().redirectUrl(redirectUrl).build()).build();
    }

    public PgPaymentRequest(String merchantOrderId, long amount, long encryptionKeyId, String authMode, String encryptedToken, String encryptedCvv, String cryptogram, String panSuffix, String expiryMonth, String expiryYear, String redirectUrl, String cardHolderName, String merchantUserId, MetaInfo metaInfo, List<InstrumentConstraint> constraints, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(TokenPaymentV2Instrument.builder().merchantUserId(merchantUserId).authMode(authMode).tokenDetails(TokenDetails.builder().cardHolderName(cardHolderName).cryptogram(cryptogram).encryptedCvv(encryptedCvv).encryptedToken(encryptedToken).encryptionKeyId(encryptionKeyId).panSuffix(panSuffix).expiry(Expiry.builder().month(expiryMonth).year(expiryYear).build()).build()).build()).merchantUrls(MerchantUrls.builder().redirectUrl(redirectUrl).build()).build();
    }

    public PgPaymentRequest(String merchantOrderId, long amount, long encryptionKeyId, String authMode, String encryptedCardNumber, String encryptedCvv, String expiryMonth, String expiryYear, String cardHolderName, String merchantUserId, MetaInfo metaInfo, List<InstrumentConstraint> constraints, String redirectUrl, Long expireAfter) {
        this(merchantOrderId, amount, metaInfo, constraints, expireAfter);
        this.paymentFlow = PgPaymentFlow.builder().paymentMode(CardPaymentV2Instrument.builder().merchantUserId(merchantUserId).authMode(authMode).cardDetails(NewCardDetails.builder().cardHolderName(cardHolderName).encryptedCvv(encryptedCvv).encryptionKeyId(encryptionKeyId).encryptedCardNumber(encryptedCardNumber).expiry(Expiry.builder().month(expiryMonth).year(expiryYear).build()).build()).build()).merchantUrls(MerchantUrls.builder().redirectUrl(redirectUrl).build()).build();
    }

    public PgPaymentRequest(String merchantOrderId, String merchantSubscriptionId, Long amount, String deviceOS, String merchantCallbackScheme, String targetApp, AuthWorkflowType authWorkflowType, Long subscriptionExpireAt, Long orderExpireAt, AmountType amountType, Frequency frequency, MetaInfo metaInfo, Long maxAmount, List<InstrumentConstraint> constraints) {
        this(merchantOrderId, amount, metaInfo, constraints, null);
        this.expireAt = orderExpireAt;
        this.deviceContext = DeviceContext.builder().deviceOS(deviceOS).merchantCallBackScheme(merchantCallbackScheme).build();
        this.paymentFlow = SubscriptionSetupPaymentFlow.builder().merchantSubscriptionId(merchantSubscriptionId).amountType(amountType).authWorkflowType(authWorkflowType).expireAt(subscriptionExpireAt).frequency(frequency).maxAmount(maxAmount).paymentMode(IntentPaymentV2Instrument.builder().targetApp(targetApp).build()).build();
    }

    public PgPaymentRequest(String merchantOrderId, String merchantSubscriptionId, Long amount, AuthWorkflowType authWorkflowType, Long subscriptionExpireAt, Long orderExpireAt, AmountType amountType, Frequency frequency, MetaInfo metaInfo, Long maxAmount, String vpa, String message, List<InstrumentConstraint> constraints) {
        this(merchantOrderId, amount, metaInfo, constraints, null);
        this.expireAt = orderExpireAt;
        this.paymentFlow = SubscriptionSetupPaymentFlow.builder().merchantSubscriptionId(merchantSubscriptionId).amountType(amountType).authWorkflowType(authWorkflowType).expireAt(subscriptionExpireAt).frequency(frequency).maxAmount(maxAmount).paymentMode(CollectPaymentV2Instrument.builder().details(VpaCollectPaymentDetails.builder().vpa(vpa).build()).message(message).build()).build();
    }

    public PgPaymentRequest(String merchantOrderId, Long amount, Long expireAt, MetaInfo metaInfo, String merchantSubscriptionId, boolean autoDebit, RedemptionRetryStrategy redemptionRetryStrategy, List<InstrumentConstraint> constraints) {
        this(merchantOrderId, amount, metaInfo, constraints, null);
        this.expireAt = expireAt;
        this.paymentFlow = SubscriptionRedemptionPaymentFlow.builder().redemptionRetryStrategy(redemptionRetryStrategy).autoDebit(autoDebit).merchantSubscriptionId(merchantSubscriptionId).build();
    }

    public static UpiIntentPayRequestBuilder UpiIntentPayRequestBuilder() {
        return new UpiIntentPayRequestBuilder();
    }

    public static UpiCollectPayViaVpaRequestBuilder UpiCollectPayViaVpaRequestBuilder() {
        return new UpiCollectPayViaVpaRequestBuilder();
    }

    public static UpiCollectPayViaPhoneNumberRequestBuilder UpiCollectPayViaPhoneNumberRequestBuilder() {
        return new UpiCollectPayViaPhoneNumberRequestBuilder();
    }

    public static UpiQrRequestBuilder UpiQrRequestBuilder() {
        return new UpiQrRequestBuilder();
    }

    public static NetBankingPayRequestBuilder NetBankingPayRequestBuilder() {
        return new NetBankingPayRequestBuilder();
    }

    public static TokenPayRequestBuilder TokenPayRequestBuilder() {
        return new TokenPayRequestBuilder();
    }

    public static CardPayRequestBuilder CardPayRequestBuilder() {
        return new CardPayRequestBuilder();
    }

    public static SubscriptionSetupUpiIntentBuilder SubscriptionSetupUpiIntentBuilder() {
        return new SubscriptionSetupUpiIntentBuilder();
    }

    public static SubscriptionSetupUpiCollectBuilder SubscriptionSetupUpiCollectBuilder() {
        return new SubscriptionSetupUpiCollectBuilder();
    }

    public static SubscriptionNotifyRequestBuilder SubscriptionNotifyRequestBuilder() {
        return new SubscriptionNotifyRequestBuilder();
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public Long getAmount() {
        return this.amount;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public PaymentFlow getPaymentFlow() {
        return this.paymentFlow;
    }

    public List<InstrumentConstraint> getConstraints() {
        return this.constraints;
    }

    public DeviceContext getDeviceContext() {
        return this.deviceContext;
    }

    public Long getExpireAfter() {
        return this.expireAfter;
    }

    public Long getExpireAt() {
        return this.expireAt;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setPaymentFlow(PaymentFlow paymentFlow) {
        this.paymentFlow = paymentFlow;
    }

    public void setConstraints(List<InstrumentConstraint> constraints) {
        this.constraints = constraints;
    }

    public void setDeviceContext(DeviceContext deviceContext) {
        this.deviceContext = deviceContext;
    }

    public void setExpireAfter(Long expireAfter) {
        this.expireAfter = expireAfter;
    }

    public void setExpireAt(Long expireAt) {
        this.expireAt = expireAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgPaymentRequest)) {
            return false;
        }
        PgPaymentRequest other = (PgPaymentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$expireAfter = this.getExpireAfter();
        Long other$expireAfter = other.getExpireAfter();
        if (this$expireAfter == null ? other$expireAfter != null : !((Object)this$expireAfter).equals(other$expireAfter)) {
            return false;
        }
        Long this$expireAt = this.getExpireAt();
        Long other$expireAt = other.getExpireAt();
        if (this$expireAt == null ? other$expireAt != null : !((Object)this$expireAt).equals(other$expireAt)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo)) {
            return false;
        }
        PaymentFlow this$paymentFlow = this.getPaymentFlow();
        PaymentFlow other$paymentFlow = other.getPaymentFlow();
        if (this$paymentFlow == null ? other$paymentFlow != null : !((Object)this$paymentFlow).equals(other$paymentFlow)) {
            return false;
        }
        List<InstrumentConstraint> this$constraints = this.getConstraints();
        List<InstrumentConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        DeviceContext this$deviceContext = this.getDeviceContext();
        DeviceContext other$deviceContext = other.getDeviceContext();
        return !(this$deviceContext == null ? other$deviceContext != null : !((Object)this$deviceContext).equals(other$deviceContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PgPaymentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $expireAfter = this.getExpireAfter();
        result = result * 59 + ($expireAfter == null ? 43 : ((Object)$expireAfter).hashCode());
        Long $expireAt = this.getExpireAt();
        result = result * 59 + ($expireAt == null ? 43 : ((Object)$expireAt).hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        PaymentFlow $paymentFlow = this.getPaymentFlow();
        result = result * 59 + ($paymentFlow == null ? 43 : ((Object)$paymentFlow).hashCode());
        List<InstrumentConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        DeviceContext $deviceContext = this.getDeviceContext();
        result = result * 59 + ($deviceContext == null ? 43 : ((Object)$deviceContext).hashCode());
        return result;
    }

    public String toString() {
        return "PgPaymentRequest(merchantOrderId=" + this.getMerchantOrderId() + ", amount=" + this.getAmount() + ", metaInfo=" + String.valueOf(this.getMetaInfo()) + ", paymentFlow=" + String.valueOf(this.getPaymentFlow()) + ", constraints=" + String.valueOf(this.getConstraints()) + ", deviceContext=" + String.valueOf(this.getDeviceContext()) + ", expireAfter=" + this.getExpireAfter() + ", expireAt=" + this.getExpireAt() + ")";
    }

    public static class UpiIntentPayRequestBuilder {
        private String merchantOrderId;
        private long amount;
        private MetaInfo metaInfo;
        private List<InstrumentConstraint> constraints;
        private String deviceOS;
        private String merchantCallBackScheme;
        private String targetApp;
        private Long expireAfter;

        UpiIntentPayRequestBuilder() {
        }

        public UpiIntentPayRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public UpiIntentPayRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public UpiIntentPayRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public UpiIntentPayRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public UpiIntentPayRequestBuilder deviceOS(String deviceOS) {
            this.deviceOS = deviceOS;
            return this;
        }

        public UpiIntentPayRequestBuilder merchantCallBackScheme(String merchantCallBackScheme) {
            this.merchantCallBackScheme = merchantCallBackScheme;
            return this;
        }

        public UpiIntentPayRequestBuilder targetApp(String targetApp) {
            this.targetApp = targetApp;
            return this;
        }

        public UpiIntentPayRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.merchantOrderId, this.amount, this.metaInfo, this.constraints, this.deviceOS, this.merchantCallBackScheme, this.targetApp, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.UpiIntentPayRequestBuilder(merchantOrderId=" + this.merchantOrderId + ", amount=" + this.amount + ", metaInfo=" + String.valueOf(this.metaInfo) + ", constraints=" + String.valueOf(this.constraints) + ", deviceOS=" + this.deviceOS + ", merchantCallBackScheme=" + this.merchantCallBackScheme + ", targetApp=" + this.targetApp + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class UpiCollectPayViaVpaRequestBuilder {
        private long amount;
        private String merchantOrderId;
        private MetaInfo metaInfo;
        private List<InstrumentConstraint> constraints;
        private String vpa;
        private String message;
        private Long expireAfter;

        UpiCollectPayViaVpaRequestBuilder() {
        }

        public UpiCollectPayViaVpaRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public UpiCollectPayViaVpaRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public UpiCollectPayViaVpaRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public UpiCollectPayViaVpaRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public UpiCollectPayViaVpaRequestBuilder vpa(String vpa) {
            this.vpa = vpa;
            return this;
        }

        public UpiCollectPayViaVpaRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public UpiCollectPayViaVpaRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.amount, this.merchantOrderId, this.metaInfo, this.constraints, this.vpa, this.message, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.UpiCollectPayViaVpaRequestBuilder(amount=" + this.amount + ", merchantOrderId=" + this.merchantOrderId + ", metaInfo=" + String.valueOf(this.metaInfo) + ", constraints=" + String.valueOf(this.constraints) + ", vpa=" + this.vpa + ", message=" + this.message + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class UpiCollectPayViaPhoneNumberRequestBuilder {
        private long amount;
        private MetaInfo metaInfo;
        private String merchantOrderId;
        private String phoneNumber;
        private List<InstrumentConstraint> constraints;
        private String message;
        private Long expireAfter;

        UpiCollectPayViaPhoneNumberRequestBuilder() {
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public UpiCollectPayViaPhoneNumberRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.amount, this.metaInfo, this.merchantOrderId, this.phoneNumber, this.constraints, this.message, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.UpiCollectPayViaPhoneNumberRequestBuilder(amount=" + this.amount + ", metaInfo=" + String.valueOf(this.metaInfo) + ", merchantOrderId=" + this.merchantOrderId + ", phoneNumber=" + this.phoneNumber + ", constraints=" + String.valueOf(this.constraints) + ", message=" + this.message + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class UpiQrRequestBuilder {
        private long amount;
        private MetaInfo metaInfo;
        private String merchantOrderId;
        private List<InstrumentConstraint> constraints;
        private Long expireAfter;

        UpiQrRequestBuilder() {
        }

        public UpiQrRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public UpiQrRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public UpiQrRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public UpiQrRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public UpiQrRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.amount, this.metaInfo, this.merchantOrderId, this.constraints, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.UpiQrRequestBuilder(amount=" + this.amount + ", metaInfo=" + String.valueOf(this.metaInfo) + ", merchantOrderId=" + this.merchantOrderId + ", constraints=" + String.valueOf(this.constraints) + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class NetBankingPayRequestBuilder {
        private long amount;
        private MetaInfo metaInfo;
        private List<InstrumentConstraint> constraints;
        private String merchantOrderId;
        private String bankId;
        private String merchantUserId;
        private String redirectUrl;
        private Long expireAfter;

        NetBankingPayRequestBuilder() {
        }

        public NetBankingPayRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public NetBankingPayRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public NetBankingPayRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public NetBankingPayRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public NetBankingPayRequestBuilder bankId(String bankId) {
            this.bankId = bankId;
            return this;
        }

        public NetBankingPayRequestBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public NetBankingPayRequestBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public NetBankingPayRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.amount, this.metaInfo, this.constraints, this.merchantOrderId, this.bankId, this.merchantUserId, this.redirectUrl, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.NetBankingPayRequestBuilder(amount=" + this.amount + ", metaInfo=" + String.valueOf(this.metaInfo) + ", constraints=" + String.valueOf(this.constraints) + ", merchantOrderId=" + this.merchantOrderId + ", bankId=" + this.bankId + ", merchantUserId=" + this.merchantUserId + ", redirectUrl=" + this.redirectUrl + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class TokenPayRequestBuilder {
        private String merchantOrderId;
        private long amount;
        private long encryptionKeyId;
        private String authMode;
        private String encryptedToken;
        private String encryptedCvv;
        private String cryptogram;
        private String panSuffix;
        private String expiryMonth;
        private String expiryYear;
        private String redirectUrl;
        private String cardHolderName;
        private String merchantUserId;
        private MetaInfo metaInfo;
        private List<InstrumentConstraint> constraints;
        private Long expireAfter;

        TokenPayRequestBuilder() {
        }

        public TokenPayRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public TokenPayRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public TokenPayRequestBuilder encryptionKeyId(long encryptionKeyId) {
            this.encryptionKeyId = encryptionKeyId;
            return this;
        }

        public TokenPayRequestBuilder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        public TokenPayRequestBuilder encryptedToken(String encryptedToken) {
            this.encryptedToken = encryptedToken;
            return this;
        }

        public TokenPayRequestBuilder encryptedCvv(String encryptedCvv) {
            this.encryptedCvv = encryptedCvv;
            return this;
        }

        public TokenPayRequestBuilder cryptogram(String cryptogram) {
            this.cryptogram = cryptogram;
            return this;
        }

        public TokenPayRequestBuilder panSuffix(String panSuffix) {
            this.panSuffix = panSuffix;
            return this;
        }

        public TokenPayRequestBuilder expiryMonth(String expiryMonth) {
            this.expiryMonth = expiryMonth;
            return this;
        }

        public TokenPayRequestBuilder expiryYear(String expiryYear) {
            this.expiryYear = expiryYear;
            return this;
        }

        public TokenPayRequestBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public TokenPayRequestBuilder cardHolderName(String cardHolderName) {
            this.cardHolderName = cardHolderName;
            return this;
        }

        public TokenPayRequestBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public TokenPayRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public TokenPayRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public TokenPayRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.merchantOrderId, this.amount, this.encryptionKeyId, this.authMode, this.encryptedToken, this.encryptedCvv, this.cryptogram, this.panSuffix, this.expiryMonth, this.expiryYear, this.redirectUrl, this.cardHolderName, this.merchantUserId, this.metaInfo, this.constraints, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.TokenPayRequestBuilder(merchantOrderId=" + this.merchantOrderId + ", amount=" + this.amount + ", encryptionKeyId=" + this.encryptionKeyId + ", authMode=" + this.authMode + ", encryptedToken=" + this.encryptedToken + ", encryptedCvv=" + this.encryptedCvv + ", cryptogram=" + this.cryptogram + ", panSuffix=" + this.panSuffix + ", expiryMonth=" + this.expiryMonth + ", expiryYear=" + this.expiryYear + ", redirectUrl=" + this.redirectUrl + ", cardHolderName=" + this.cardHolderName + ", merchantUserId=" + this.merchantUserId + ", metaInfo=" + String.valueOf(this.metaInfo) + ", constraints=" + String.valueOf(this.constraints) + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class CardPayRequestBuilder {
        private String merchantOrderId;
        private long amount;
        private long encryptionKeyId;
        private String authMode;
        private String encryptedCardNumber;
        private String encryptedCvv;
        private String expiryMonth;
        private String expiryYear;
        private String cardHolderName;
        private String merchantUserId;
        private MetaInfo metaInfo;
        private List<InstrumentConstraint> constraints;
        private String redirectUrl;
        private Long expireAfter;

        CardPayRequestBuilder() {
        }

        public CardPayRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public CardPayRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public CardPayRequestBuilder encryptionKeyId(long encryptionKeyId) {
            this.encryptionKeyId = encryptionKeyId;
            return this;
        }

        public CardPayRequestBuilder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        public CardPayRequestBuilder encryptedCardNumber(String encryptedCardNumber) {
            this.encryptedCardNumber = encryptedCardNumber;
            return this;
        }

        public CardPayRequestBuilder encryptedCvv(String encryptedCvv) {
            this.encryptedCvv = encryptedCvv;
            return this;
        }

        public CardPayRequestBuilder expiryMonth(String expiryMonth) {
            this.expiryMonth = expiryMonth;
            return this;
        }

        public CardPayRequestBuilder expiryYear(String expiryYear) {
            this.expiryYear = expiryYear;
            return this;
        }

        public CardPayRequestBuilder cardHolderName(String cardHolderName) {
            this.cardHolderName = cardHolderName;
            return this;
        }

        public CardPayRequestBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public CardPayRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public CardPayRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public CardPayRequestBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public CardPayRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.merchantOrderId, this.amount, this.encryptionKeyId, this.authMode, this.encryptedCardNumber, this.encryptedCvv, this.expiryMonth, this.expiryYear, this.cardHolderName, this.merchantUserId, this.metaInfo, this.constraints, this.redirectUrl, this.expireAfter);
        }

        public String toString() {
            return "PgPaymentRequest.CardPayRequestBuilder(merchantOrderId=" + this.merchantOrderId + ", amount=" + this.amount + ", encryptionKeyId=" + this.encryptionKeyId + ", authMode=" + this.authMode + ", encryptedCardNumber=" + this.encryptedCardNumber + ", encryptedCvv=" + this.encryptedCvv + ", expiryMonth=" + this.expiryMonth + ", expiryYear=" + this.expiryYear + ", cardHolderName=" + this.cardHolderName + ", merchantUserId=" + this.merchantUserId + ", metaInfo=" + String.valueOf(this.metaInfo) + ", constraints=" + String.valueOf(this.constraints) + ", redirectUrl=" + this.redirectUrl + ", expireAfter=" + this.expireAfter + ")";
        }
    }

    public static class SubscriptionSetupUpiIntentBuilder {
        private String merchantOrderId;
        private String merchantSubscriptionId;
        private Long amount;
        private String deviceOS;
        private String merchantCallbackScheme;
        private String targetApp;
        private AuthWorkflowType authWorkflowType;
        private Long subscriptionExpireAt;
        private Long orderExpireAt;
        private AmountType amountType;
        private Frequency frequency;
        private MetaInfo metaInfo;
        private Long maxAmount;
        private List<InstrumentConstraint> constraints;

        SubscriptionSetupUpiIntentBuilder() {
        }

        public SubscriptionSetupUpiIntentBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder merchantSubscriptionId(String merchantSubscriptionId) {
            this.merchantSubscriptionId = merchantSubscriptionId;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder deviceOS(String deviceOS) {
            this.deviceOS = deviceOS;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder merchantCallbackScheme(String merchantCallbackScheme) {
            this.merchantCallbackScheme = merchantCallbackScheme;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder targetApp(String targetApp) {
            this.targetApp = targetApp;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder authWorkflowType(AuthWorkflowType authWorkflowType) {
            this.authWorkflowType = authWorkflowType;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder subscriptionExpireAt(Long subscriptionExpireAt) {
            this.subscriptionExpireAt = subscriptionExpireAt;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder orderExpireAt(Long orderExpireAt) {
            this.orderExpireAt = orderExpireAt;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder amountType(AmountType amountType) {
            this.amountType = amountType;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder frequency(Frequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder maxAmount(Long maxAmount) {
            this.maxAmount = maxAmount;
            return this;
        }

        public SubscriptionSetupUpiIntentBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.merchantOrderId, this.merchantSubscriptionId, this.amount, this.deviceOS, this.merchantCallbackScheme, this.targetApp, this.authWorkflowType, this.subscriptionExpireAt, this.orderExpireAt, this.amountType, this.frequency, this.metaInfo, this.maxAmount, this.constraints);
        }

        public String toString() {
            return "PgPaymentRequest.SubscriptionSetupUpiIntentBuilder(merchantOrderId=" + this.merchantOrderId + ", merchantSubscriptionId=" + this.merchantSubscriptionId + ", amount=" + this.amount + ", deviceOS=" + this.deviceOS + ", merchantCallbackScheme=" + this.merchantCallbackScheme + ", targetApp=" + this.targetApp + ", authWorkflowType=" + String.valueOf((Object)this.authWorkflowType) + ", subscriptionExpireAt=" + this.subscriptionExpireAt + ", orderExpireAt=" + this.orderExpireAt + ", amountType=" + String.valueOf((Object)this.amountType) + ", frequency=" + String.valueOf((Object)this.frequency) + ", metaInfo=" + String.valueOf(this.metaInfo) + ", maxAmount=" + this.maxAmount + ", constraints=" + String.valueOf(this.constraints) + ")";
        }
    }

    public static class SubscriptionSetupUpiCollectBuilder {
        private String merchantOrderId;
        private String merchantSubscriptionId;
        private Long amount;
        private AuthWorkflowType authWorkflowType;
        private Long subscriptionExpireAt;
        private Long orderExpireAt;
        private AmountType amountType;
        private Frequency frequency;
        private MetaInfo metaInfo;
        private Long maxAmount;
        private String vpa;
        private String message;
        private List<InstrumentConstraint> constraints;

        SubscriptionSetupUpiCollectBuilder() {
        }

        public SubscriptionSetupUpiCollectBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder merchantSubscriptionId(String merchantSubscriptionId) {
            this.merchantSubscriptionId = merchantSubscriptionId;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder authWorkflowType(AuthWorkflowType authWorkflowType) {
            this.authWorkflowType = authWorkflowType;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder subscriptionExpireAt(Long subscriptionExpireAt) {
            this.subscriptionExpireAt = subscriptionExpireAt;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder orderExpireAt(Long orderExpireAt) {
            this.orderExpireAt = orderExpireAt;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder amountType(AmountType amountType) {
            this.amountType = amountType;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder frequency(Frequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder maxAmount(Long maxAmount) {
            this.maxAmount = maxAmount;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder vpa(String vpa) {
            this.vpa = vpa;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SubscriptionSetupUpiCollectBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.merchantOrderId, this.merchantSubscriptionId, this.amount, this.authWorkflowType, this.subscriptionExpireAt, this.orderExpireAt, this.amountType, this.frequency, this.metaInfo, this.maxAmount, this.vpa, this.message, this.constraints);
        }

        public String toString() {
            return "PgPaymentRequest.SubscriptionSetupUpiCollectBuilder(merchantOrderId=" + this.merchantOrderId + ", merchantSubscriptionId=" + this.merchantSubscriptionId + ", amount=" + this.amount + ", authWorkflowType=" + String.valueOf((Object)this.authWorkflowType) + ", subscriptionExpireAt=" + this.subscriptionExpireAt + ", orderExpireAt=" + this.orderExpireAt + ", amountType=" + String.valueOf((Object)this.amountType) + ", frequency=" + String.valueOf((Object)this.frequency) + ", metaInfo=" + String.valueOf(this.metaInfo) + ", maxAmount=" + this.maxAmount + ", vpa=" + this.vpa + ", message=" + this.message + ", constraints=" + String.valueOf(this.constraints) + ")";
        }
    }

    public static class SubscriptionNotifyRequestBuilder {
        private String merchantOrderId;
        private Long amount;
        private Long expireAt;
        private MetaInfo metaInfo;
        private String merchantSubscriptionId;
        private boolean autoDebit;
        private RedemptionRetryStrategy redemptionRetryStrategy;
        private List<InstrumentConstraint> constraints;

        SubscriptionNotifyRequestBuilder() {
        }

        public SubscriptionNotifyRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public SubscriptionNotifyRequestBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public SubscriptionNotifyRequestBuilder expireAt(Long expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public SubscriptionNotifyRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public SubscriptionNotifyRequestBuilder merchantSubscriptionId(String merchantSubscriptionId) {
            this.merchantSubscriptionId = merchantSubscriptionId;
            return this;
        }

        public SubscriptionNotifyRequestBuilder autoDebit(boolean autoDebit) {
            this.autoDebit = autoDebit;
            return this;
        }

        public SubscriptionNotifyRequestBuilder redemptionRetryStrategy(RedemptionRetryStrategy redemptionRetryStrategy) {
            this.redemptionRetryStrategy = redemptionRetryStrategy;
            return this;
        }

        public SubscriptionNotifyRequestBuilder constraints(List<InstrumentConstraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public PgPaymentRequest build() {
            return new PgPaymentRequest(this.merchantOrderId, this.amount, this.expireAt, this.metaInfo, this.merchantSubscriptionId, this.autoDebit, this.redemptionRetryStrategy, this.constraints);
        }

        public String toString() {
            return "PgPaymentRequest.SubscriptionNotifyRequestBuilder(merchantOrderId=" + this.merchantOrderId + ", amount=" + this.amount + ", expireAt=" + this.expireAt + ", metaInfo=" + String.valueOf(this.metaInfo) + ", merchantSubscriptionId=" + this.merchantSubscriptionId + ", autoDebit=" + this.autoDebit + ", redemptionRetryStrategy=" + String.valueOf((Object)this.redemptionRetryStrategy) + ", constraints=" + String.valueOf(this.constraints) + ")";
        }
    }
}

