/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.models.request.instruments;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.PgV2InstrumentType;
import com.phonepe.sdk.pg.common.models.request.instruments.PaymentV2Instrument;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NetBankingPaymentV2Instrument
extends PaymentV2Instrument {
    private String bankId;
    private String merchantUserId;

    public NetBankingPaymentV2Instrument(String bankId, String merchantUserId) {
        super(PgV2InstrumentType.NET_BANKING);
        this.bankId = bankId;
        this.merchantUserId = merchantUserId;
    }

    public static NetBankingPaymentV2InstrumentBuilder builder() {
        return new NetBankingPaymentV2InstrumentBuilder();
    }

    public String getBankId() {
        return this.bankId;
    }

    public String getMerchantUserId() {
        return this.merchantUserId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public void setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
    }

    public String toString() {
        return "NetBankingPaymentV2Instrument(bankId=" + this.getBankId() + ", merchantUserId=" + this.getMerchantUserId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetBankingPaymentV2Instrument)) {
            return false;
        }
        NetBankingPaymentV2Instrument other = (NetBankingPaymentV2Instrument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bankId = this.getBankId();
        String other$bankId = other.getBankId();
        if (this$bankId == null ? other$bankId != null : !this$bankId.equals(other$bankId)) {
            return false;
        }
        String this$merchantUserId = this.getMerchantUserId();
        String other$merchantUserId = other.getMerchantUserId();
        return !(this$merchantUserId == null ? other$merchantUserId != null : !this$merchantUserId.equals(other$merchantUserId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetBankingPaymentV2Instrument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bankId = this.getBankId();
        result = result * 59 + ($bankId == null ? 43 : $bankId.hashCode());
        String $merchantUserId = this.getMerchantUserId();
        result = result * 59 + ($merchantUserId == null ? 43 : $merchantUserId.hashCode());
        return result;
    }

    public static class NetBankingPaymentV2InstrumentBuilder {
        private String bankId;
        private String merchantUserId;

        NetBankingPaymentV2InstrumentBuilder() {
        }

        public NetBankingPaymentV2InstrumentBuilder bankId(String bankId) {
            this.bankId = bankId;
            return this;
        }

        public NetBankingPaymentV2InstrumentBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public NetBankingPaymentV2Instrument build() {
            return new NetBankingPaymentV2Instrument(this.bankId, this.merchantUserId);
        }

        public String toString() {
            return "NetBankingPaymentV2Instrument.NetBankingPaymentV2InstrumentBuilder(bankId=" + this.bankId + ", merchantUserId=" + this.merchantUserId + ")";
        }
    }
}

