/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.common.tokenhandler;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthResponse {
    @JsonAlias(value={"access_token"})
    private String accessToken;
    @JsonAlias(value={"encrypted_access_token"})
    private String encryptedAccessToken;
    @JsonAlias(value={"refresh_token"})
    private String refreshToken;
    @JsonAlias(value={"expires_in"})
    private int expiresIn;
    @JsonAlias(value={"issued_at"})
    private long issuedAt;
    @JsonAlias(value={"expires_at"})
    private long expiresAt;
    @JsonAlias(value={"session_expires_at"})
    private long sessionExpiresAt;
    @JsonAlias(value={"token_type"})
    private String tokenType;

    public static OAuthResponseBuilder builder() {
        return new OAuthResponseBuilder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getEncryptedAccessToken() {
        return this.encryptedAccessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public long getSessionExpiresAt() {
        return this.sessionExpiresAt;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    @JsonAlias(value={"access_token"})
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JsonAlias(value={"encrypted_access_token"})
    public void setEncryptedAccessToken(String encryptedAccessToken) {
        this.encryptedAccessToken = encryptedAccessToken;
    }

    @JsonAlias(value={"refresh_token"})
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonAlias(value={"expires_in"})
    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonAlias(value={"issued_at"})
    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    @JsonAlias(value={"expires_at"})
    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @JsonAlias(value={"session_expires_at"})
    public void setSessionExpiresAt(long sessionExpiresAt) {
        this.sessionExpiresAt = sessionExpiresAt;
    }

    @JsonAlias(value={"token_type"})
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthResponse)) {
            return false;
        }
        OAuthResponse other = (OAuthResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        if (this.getIssuedAt() != other.getIssuedAt()) {
            return false;
        }
        if (this.getExpiresAt() != other.getExpiresAt()) {
            return false;
        }
        if (this.getSessionExpiresAt() != other.getSessionExpiresAt()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$encryptedAccessToken = this.getEncryptedAccessToken();
        String other$encryptedAccessToken = other.getEncryptedAccessToken();
        if (this$encryptedAccessToken == null ? other$encryptedAccessToken != null : !this$encryptedAccessToken.equals(other$encryptedAccessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        return !(this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiresIn();
        long $issuedAt = this.getIssuedAt();
        result = result * 59 + (int)($issuedAt >>> 32 ^ $issuedAt);
        long $expiresAt = this.getExpiresAt();
        result = result * 59 + (int)($expiresAt >>> 32 ^ $expiresAt);
        long $sessionExpiresAt = this.getSessionExpiresAt();
        result = result * 59 + (int)($sessionExpiresAt >>> 32 ^ $sessionExpiresAt);
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $encryptedAccessToken = this.getEncryptedAccessToken();
        result = result * 59 + ($encryptedAccessToken == null ? 43 : $encryptedAccessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        return result;
    }

    public String toString() {
        return "OAuthResponse(accessToken=" + this.getAccessToken() + ", encryptedAccessToken=" + this.getEncryptedAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", expiresIn=" + this.getExpiresIn() + ", issuedAt=" + this.getIssuedAt() + ", expiresAt=" + this.getExpiresAt() + ", sessionExpiresAt=" + this.getSessionExpiresAt() + ", tokenType=" + this.getTokenType() + ")";
    }

    public OAuthResponse() {
    }

    public OAuthResponse(String accessToken, String encryptedAccessToken, String refreshToken, int expiresIn, long issuedAt, long expiresAt, long sessionExpiresAt, String tokenType) {
        this.accessToken = accessToken;
        this.encryptedAccessToken = encryptedAccessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.issuedAt = issuedAt;
        this.expiresAt = expiresAt;
        this.sessionExpiresAt = sessionExpiresAt;
        this.tokenType = tokenType;
    }

    public static class OAuthResponseBuilder {
        private String accessToken;
        private String encryptedAccessToken;
        private String refreshToken;
        private int expiresIn;
        private long issuedAt;
        private long expiresAt;
        private long sessionExpiresAt;
        private String tokenType;

        OAuthResponseBuilder() {
        }

        @JsonAlias(value={"access_token"})
        public OAuthResponseBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @JsonAlias(value={"encrypted_access_token"})
        public OAuthResponseBuilder encryptedAccessToken(String encryptedAccessToken) {
            this.encryptedAccessToken = encryptedAccessToken;
            return this;
        }

        @JsonAlias(value={"refresh_token"})
        public OAuthResponseBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @JsonAlias(value={"expires_in"})
        public OAuthResponseBuilder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @JsonAlias(value={"issued_at"})
        public OAuthResponseBuilder issuedAt(long issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        @JsonAlias(value={"expires_at"})
        public OAuthResponseBuilder expiresAt(long expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @JsonAlias(value={"session_expires_at"})
        public OAuthResponseBuilder sessionExpiresAt(long sessionExpiresAt) {
            this.sessionExpiresAt = sessionExpiresAt;
            return this;
        }

        @JsonAlias(value={"token_type"})
        public OAuthResponseBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public OAuthResponse build() {
            return new OAuthResponse(this.accessToken, this.encryptedAccessToken, this.refreshToken, this.expiresIn, this.issuedAt, this.expiresAt, this.sessionExpiresAt, this.tokenType);
        }

        public String toString() {
            return "OAuthResponse.OAuthResponseBuilder(accessToken=" + this.accessToken + ", encryptedAccessToken=" + this.encryptedAccessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", issuedAt=" + this.issuedAt + ", expiresAt=" + this.expiresAt + ", sessionExpiresAt=" + this.sessionExpiresAt + ", tokenType=" + this.tokenType + ")";
        }
    }
}

