/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.payments.v2.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.PaymentFlowType;
import com.phonepe.sdk.pg.common.models.request.PaymentFlow;
import com.phonepe.sdk.pg.common.models.request.instruments.PaymentV2Instrument;
import com.phonepe.sdk.pg.payments.v2.models.request.MerchantUrls;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PgPaymentFlow
extends PaymentFlow {
    private PaymentV2Instrument paymentMode;
    private MerchantUrls merchantUrls;

    public PgPaymentFlow(PaymentV2Instrument paymentMode, MerchantUrls merchantUrls) {
        super(PaymentFlowType.PG);
        this.paymentMode = paymentMode;
        this.merchantUrls = merchantUrls;
    }

    public static PgPaymentFlowBuilder builder() {
        return new PgPaymentFlowBuilder();
    }

    public PaymentV2Instrument getPaymentMode() {
        return this.paymentMode;
    }

    public MerchantUrls getMerchantUrls() {
        return this.merchantUrls;
    }

    public void setPaymentMode(PaymentV2Instrument paymentMode) {
        this.paymentMode = paymentMode;
    }

    public void setMerchantUrls(MerchantUrls merchantUrls) {
        this.merchantUrls = merchantUrls;
    }

    @Override
    public String toString() {
        return "PgPaymentFlow(paymentMode=" + String.valueOf(this.getPaymentMode()) + ", merchantUrls=" + String.valueOf(this.getMerchantUrls()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgPaymentFlow)) {
            return false;
        }
        PgPaymentFlow other = (PgPaymentFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PaymentV2Instrument this$paymentMode = this.getPaymentMode();
        PaymentV2Instrument other$paymentMode = other.getPaymentMode();
        if (this$paymentMode == null ? other$paymentMode != null : !this$paymentMode.equals(other$paymentMode)) {
            return false;
        }
        MerchantUrls this$merchantUrls = this.getMerchantUrls();
        MerchantUrls other$merchantUrls = other.getMerchantUrls();
        return !(this$merchantUrls == null ? other$merchantUrls != null : !((Object)this$merchantUrls).equals(other$merchantUrls));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PgPaymentFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PaymentV2Instrument $paymentMode = this.getPaymentMode();
        result = result * 59 + ($paymentMode == null ? 43 : $paymentMode.hashCode());
        MerchantUrls $merchantUrls = this.getMerchantUrls();
        result = result * 59 + ($merchantUrls == null ? 43 : ((Object)$merchantUrls).hashCode());
        return result;
    }

    public static class PgPaymentFlowBuilder {
        private PaymentV2Instrument paymentMode;
        private MerchantUrls merchantUrls;

        PgPaymentFlowBuilder() {
        }

        public PgPaymentFlowBuilder paymentMode(PaymentV2Instrument paymentMode) {
            this.paymentMode = paymentMode;
            return this;
        }

        public PgPaymentFlowBuilder merchantUrls(MerchantUrls merchantUrls) {
            this.merchantUrls = merchantUrls;
            return this;
        }

        public PgPaymentFlow build() {
            return new PgPaymentFlow(this.paymentMode, this.merchantUrls);
        }

        public String toString() {
            return "PgPaymentFlow.PgPaymentFlowBuilder(paymentMode=" + String.valueOf(this.paymentMode) + ", merchantUrls=" + String.valueOf(this.merchantUrls) + ")";
        }
    }
}

