/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.pg.payments.v2.models.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.phonepe.sdk.pg.common.models.MetaInfo;
import com.phonepe.sdk.pg.common.models.request.PaymentFlow;
import com.phonepe.sdk.pg.payments.v2.models.request.MerchantUrls;
import com.phonepe.sdk.pg.payments.v2.models.request.PaymentModeConfig;
import com.phonepe.sdk.pg.payments.v2.models.request.PgCheckoutPaymentFlow;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StandardCheckoutPayRequest {
    private String merchantOrderId;
    private long amount;
    private MetaInfo metaInfo;
    private PaymentFlow paymentFlow;
    private Long expireAfter;
    private Boolean disablePaymentRetry;

    public StandardCheckoutPayRequest(String merchantOrderId, long amount, String redirectUrl, MetaInfo metaInfo, String message, Long expireAfter, PaymentModeConfig paymentModeConfig, Boolean disablePaymentRetry) {
        this.merchantOrderId = merchantOrderId;
        this.amount = amount;
        this.metaInfo = metaInfo;
        this.expireAfter = expireAfter;
        MerchantUrls merchantUrls = MerchantUrls.builder().redirectUrl(redirectUrl).build();
        this.setPaymentFlow(PgCheckoutPaymentFlow.builder().message(message).merchantUrls(merchantUrls).paymentModeConfig(paymentModeConfig).build());
        this.disablePaymentRetry = disablePaymentRetry;
    }

    public static StandardCheckoutPayRequestBuilder builder() {
        return new StandardCheckoutPayRequestBuilder();
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public long getAmount() {
        return this.amount;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public PaymentFlow getPaymentFlow() {
        return this.paymentFlow;
    }

    public Long getExpireAfter() {
        return this.expireAfter;
    }

    public Boolean getDisablePaymentRetry() {
        return this.disablePaymentRetry;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setPaymentFlow(PaymentFlow paymentFlow) {
        this.paymentFlow = paymentFlow;
    }

    public void setExpireAfter(Long expireAfter) {
        this.expireAfter = expireAfter;
    }

    public void setDisablePaymentRetry(Boolean disablePaymentRetry) {
        this.disablePaymentRetry = disablePaymentRetry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardCheckoutPayRequest)) {
            return false;
        }
        StandardCheckoutPayRequest other = (StandardCheckoutPayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        Long this$expireAfter = this.getExpireAfter();
        Long other$expireAfter = other.getExpireAfter();
        if (this$expireAfter == null ? other$expireAfter != null : !((Object)this$expireAfter).equals(other$expireAfter)) {
            return false;
        }
        Boolean this$disablePaymentRetry = this.getDisablePaymentRetry();
        Boolean other$disablePaymentRetry = other.getDisablePaymentRetry();
        if (this$disablePaymentRetry == null ? other$disablePaymentRetry != null : !((Object)this$disablePaymentRetry).equals(other$disablePaymentRetry)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo)) {
            return false;
        }
        PaymentFlow this$paymentFlow = this.getPaymentFlow();
        PaymentFlow other$paymentFlow = other.getPaymentFlow();
        return !(this$paymentFlow == null ? other$paymentFlow != null : !((Object)this$paymentFlow).equals(other$paymentFlow));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandardCheckoutPayRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        Long $expireAfter = this.getExpireAfter();
        result = result * 59 + ($expireAfter == null ? 43 : ((Object)$expireAfter).hashCode());
        Boolean $disablePaymentRetry = this.getDisablePaymentRetry();
        result = result * 59 + ($disablePaymentRetry == null ? 43 : ((Object)$disablePaymentRetry).hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        PaymentFlow $paymentFlow = this.getPaymentFlow();
        result = result * 59 + ($paymentFlow == null ? 43 : ((Object)$paymentFlow).hashCode());
        return result;
    }

    public String toString() {
        return "StandardCheckoutPayRequest(merchantOrderId=" + this.getMerchantOrderId() + ", amount=" + this.getAmount() + ", metaInfo=" + String.valueOf(this.getMetaInfo()) + ", paymentFlow=" + String.valueOf(this.getPaymentFlow()) + ", expireAfter=" + this.getExpireAfter() + ", disablePaymentRetry=" + this.getDisablePaymentRetry() + ")";
    }

    public static class StandardCheckoutPayRequestBuilder {
        private String merchantOrderId;
        private long amount;
        private String redirectUrl;
        private MetaInfo metaInfo;
        private String message;
        private Long expireAfter;
        private PaymentModeConfig paymentModeConfig;
        private Boolean disablePaymentRetry;

        StandardCheckoutPayRequestBuilder() {
        }

        public StandardCheckoutPayRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public StandardCheckoutPayRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public StandardCheckoutPayRequestBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public StandardCheckoutPayRequestBuilder metaInfo(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            return this;
        }

        public StandardCheckoutPayRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public StandardCheckoutPayRequestBuilder expireAfter(Long expireAfter) {
            this.expireAfter = expireAfter;
            return this;
        }

        public StandardCheckoutPayRequestBuilder paymentModeConfig(PaymentModeConfig paymentModeConfig) {
            this.paymentModeConfig = paymentModeConfig;
            return this;
        }

        public StandardCheckoutPayRequestBuilder disablePaymentRetry(Boolean disablePaymentRetry) {
            this.disablePaymentRetry = disablePaymentRetry;
            return this;
        }

        public StandardCheckoutPayRequest build() {
            return new StandardCheckoutPayRequest(this.merchantOrderId, this.amount, this.redirectUrl, this.metaInfo, this.message, this.expireAfter, this.paymentModeConfig, this.disablePaymentRetry);
        }

        public String toString() {
            return "StandardCheckoutPayRequest.StandardCheckoutPayRequestBuilder(merchantOrderId=" + this.merchantOrderId + ", amount=" + this.amount + ", redirectUrl=" + this.redirectUrl + ", metaInfo=" + String.valueOf(this.metaInfo) + ", message=" + this.message + ", expireAfter=" + this.expireAfter + ", paymentModeConfig=" + String.valueOf(this.paymentModeConfig) + ", disablePaymentRetry=" + this.disablePaymentRetry + ")";
        }
    }
}

