/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus;

import com.pingplusplus.net.APIResource;
import com.pingplusplus.util.StreamUtils;
import java.io.FileInputStream;
import java.io.IOException;

public abstract class Pingpp {
    public static final String LIVE_API_BASE = "https://api.pingxx.com";
    public static final String VERSION = "2.5.0";
    public static volatile String apiKey;
    public static volatile String appId;
    public static String acceptLanguage;
    private static volatile String apiBase;
    public static volatile String privateKey;
    public static volatile String verifyPublicKey;
    public static volatile String privateKeyPath;
    public static Boolean DEBUG;
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 80000;
    private static volatile int connectTimeout;
    private static volatile int readTimeout;
    private static volatile int maxNetworkRetries;

    public static void overrideApiBase(String overriddenApiBase) {
        apiBase = overriddenApiBase;
    }

    public static String getApiBase() {
        return apiBase;
    }

    public static void setApiBase(String apiBase) {
        Pingpp.apiBase = apiBase;
    }

    public static int getConnectTimeout() {
        if (connectTimeout == -1) {
            return 30000;
        }
        return connectTimeout;
    }

    public static void setConnectTimeout(int timeout) {
        connectTimeout = timeout;
    }

    public static int getReadTimeout() {
        if (readTimeout == -1) {
            return 80000;
        }
        return readTimeout;
    }

    public static void setReadTimeout(int timeout) {
        readTimeout = timeout;
    }

    public static int getMaxNetworkRetries() {
        return maxNetworkRetries;
    }

    public static void setMaxNetworkRetries(int numRetries) {
        maxNetworkRetries = numRetries;
    }

    public static String getAcceptLanguage() {
        return acceptLanguage;
    }

    public static void setAcceptLanguage(String acceptLanguage) {
        Pingpp.acceptLanguage = acceptLanguage;
    }

    public static void setVerifyPublicKeyPath(String keyFilePath) throws IOException {
        verifyPublicKey = Pingpp.readKeyFromFilePath(keyFilePath);
    }

    private static String readKeyFromFilePath(String filePath) throws IOException {
        FileInputStream inputStream = new FileInputStream(filePath);
        String privateKey = StreamUtils.readToEnd(inputStream, APIResource.CHARSET);
        inputStream.close();
        return privateKey;
    }

    static {
        acceptLanguage = "zh-CN";
        apiBase = LIVE_API_BASE;
        DEBUG = false;
        connectTimeout = -1;
        readTimeout = -1;
        maxNetworkRetries = 1;
    }
}

