/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.PingppException;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.net.PingppRequest;
import com.pingplusplus.net.PingppResponse;
import com.pingplusplus.net.RequestOptions;
import com.pingplusplus.util.PingppSignature;
import com.pingplusplus.util.StreamUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;

public abstract class HttpClient {
    public static final long maxNetworkRetriesDelay = 5000L;
    public static final long minNetworkRetriesDelay = 500L;
    boolean networkRetriesSleep = true;

    public abstract PingppResponse request(PingppRequest var1) throws PingppException;

    public PingppResponse requestWithRetries(PingppRequest request) throws PingppException {
        APIConnectionException requestException = null;
        PingppResponse response = null;
        int retry = 0;
        while (true) {
            requestException = null;
            try {
                response = this.request(request);
            }
            catch (APIConnectionException e) {
                requestException = e;
            }
            if (!this.shouldRetry(retry, requestException, request, response)) break;
            ++retry;
            try {
                Thread.sleep(this.sleepTime(retry));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        response.setNumRetries(retry);
        return response;
    }

    protected static String buildUserAgentString() {
        return String.format("Pingpp/v1 JavaBindings/%s", "2.5.0");
    }

    protected static String buildXPingppClientUserAgentString() {
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "2.5.0");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Pingpp");
        return APIResource.GSON.toJson(propertyMap);
    }

    protected static String buildPingppSignature(PingppRequest request, String currentTime) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (request.content != null) {
            sb.append(request.content.stringContent());
        }
        sb.append(HttpClient.getRequestURIFromURL(request.url));
        sb.append(currentTime);
        String stringToBeSigned = sb.toString();
        return HttpClient.generateSign(stringToBeSigned, request.options);
    }

    private boolean shouldRetry(int numRetries, PingppException exception, PingppRequest request, PingppResponse response) {
        if (numRetries >= request.options.getMaxNetworkRetries()) {
            return false;
        }
        if (exception != null && exception.getCause() != null && exception.getCause() instanceof ConnectException) {
            return true;
        }
        return response != null && response.getResponseCode() >= 500;
    }

    private long sleepTime(int numRetries) {
        double jitter;
        if (!this.networkRetriesSleep) {
            return 0L;
        }
        long delay = (long)(500.0 * Math.pow(2.0, numRetries - 1));
        if (delay > 5000L) {
            delay = 5000L;
        }
        if ((delay = (long)((double)delay * (jitter = ThreadLocalRandom.current().nextDouble(0.75, 1.0)))) < 500L) {
            delay = 500L;
        }
        return delay;
    }

    protected static String currentTimeString() {
        int requestTime = (int)(System.currentTimeMillis() / 1000L);
        return Integer.toString(requestTime);
    }

    private static String getRequestURIFromURL(URL url) {
        String path = url.getPath();
        String query = url.getQuery();
        if (query == null) {
            return path;
        }
        return path + "?" + query;
    }

    private static String generateSign(String data, RequestOptions options) throws IOException {
        String privatekey = options.getPrivateKey();
        if (privatekey == null) {
            if (Pingpp.privateKeyPath == null) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(Pingpp.privateKeyPath);
            privatekey = StreamUtils.readToEnd(inputStream, APIResource.CHARSET);
            inputStream.close();
        }
        return PingppSignature.sign(data, privatekey, APIResource.CHARSET.name());
    }
}

