/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.util;

import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.net.HttpHeaders;
import com.pingplusplus.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class PingppSignature {
    public static String sign(String data, String PEMEncodedPrivateKey, String charset) {
        PrivateKey privateKey = PingppSignature.getPrivateKeyFromPEM(PEMEncodedPrivateKey);
        if (privateKey == null) {
            return null;
        }
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(data.getBytes(charset));
            byte[] signBytes = signature.sign();
            return Base64.encodeBase64String((byte[])signBytes).replaceAll("[\n\r]", "");
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean verify(String encodedSign, String data, String PEMEncodedPublicKey, String charset) throws AuthenticationException {
        if (StringUtils.isBlank(PEMEncodedPublicKey)) {
            return true;
        }
        PublicKey publicKey = PingppSignature.getPublicKeyFromPEM(PEMEncodedPublicKey);
        if (publicKey == null) {
            return true;
        }
        if (StringUtils.isBlank(encodedSign)) {
            throw new AuthenticationException("\u54cd\u5e94\u7b7e\u540d (X-Pingplusplus-Signature) \u4e3a\u7a7a");
        }
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(publicKey);
            signature.update(data.getBytes(charset));
            return signature.verify(Base64.decodeBase64((String)encodedSign));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            if (Pingpp.DEBUG.booleanValue()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean verify(HttpHeaders headers, String data, String PEMEncodedPublicKey, String charset) throws AuthenticationException {
        if (StringUtils.isBlank(PEMEncodedPublicKey)) {
            return true;
        }
        PublicKey publicKey = PingppSignature.getPublicKeyFromPEM(PEMEncodedPublicKey);
        if (publicKey == null) {
            return true;
        }
        if (!headers.firstValue("X-Pingplusplus-Signature").isPresent()) {
            throw new AuthenticationException("\u54cd\u5e94\u7b7e\u540d (X-Pingplusplus-Signature) \u4e3a\u7a7a");
        }
        String encodedSign = headers.firstValue("X-Pingplusplus-Signature").get();
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(publicKey);
            signature.update(data.getBytes(charset));
            return signature.verify(Base64.decodeBase64((String)encodedSign));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            if (Pingpp.DEBUG.booleanValue()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static PrivateKey getPrivateKeyFromPEM(String PEMEncodedPrivateKey) {
        PEMEncodedPrivateKey = PEMEncodedPrivateKey.replaceAll("(-+BEGIN (RSA )?PRIVATE KEY-+\\r?\\n|-+END (RSA )?PRIVATE KEY-+\\r?\\n?)", "");
        byte[] privateKeyBytes = Base64.decodeBase64((String)PEMEncodedPrivateKey);
        try {
            return PingppSignature.generatePrivateKeyWithPKCS8(privateKeyBytes);
        }
        catch (InvalidKeySpecException e) {
            if (Pingpp.DEBUG.booleanValue()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static PrivateKey generatePrivateKeyWithPKCS8(byte[] privateKeyBytes) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PublicKey getPublicKeyFromPEM(String PEMEncodedPublicKey) {
        PEMEncodedPublicKey = PEMEncodedPublicKey.replaceAll("(-+BEGIN (RSA )?PUBLIC KEY-+\\r?\\n|-+END (RSA )?PUBLIC KEY-+\\r?\\n?)", "");
        byte[] publicKeyBytes = Base64.decodeBase64((String)PEMEncodedPublicKey);
        try {
            return PingppSignature.generatePublicKey(publicKeyBytes);
        }
        catch (InvalidKeySpecException e) {
            if (Pingpp.DEBUG.booleanValue()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static PublicKey generatePublicKey(byte[] publicKeyBytes) throws InvalidKeySpecException {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

