/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.net.HttpClient;
import com.pingplusplus.net.HttpHeaders;
import com.pingplusplus.net.PingppRequest;
import com.pingplusplus.net.PingppResponse;
import com.pingplusplus.util.PingppSignature;
import com.pingplusplus.util.StreamUtils;
import com.pingplusplus.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionClient
extends HttpClient {
    @Override
    public PingppResponse request(PingppRequest request) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            String responseBody;
            conn = HttpURLConnectionClient.createPingppConnection(request);
            int responseCode = conn.getResponseCode();
            HttpHeaders headers = HttpHeaders.of(conn.getHeaderFields());
            if (responseCode >= 200 && responseCode < 300) {
                responseBody = StreamUtils.readToEnd(conn.getInputStream(), APIResource.CHARSET);
                boolean verified = PingppSignature.verify(headers, responseBody, request.options.getVerifyPublicKey(), APIResource.CHARSET.name());
                if (!verified) {
                    throw new AuthenticationException("\u54cd\u5e94\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9a8c\u7b7e\u516c\u94a5\u662f\u5426\u6b63\u786e");
                }
            } else {
                responseBody = StreamUtils.readToEnd(conn.getErrorStream(), APIResource.CHARSET);
            }
            PingppResponse pingppResponse = new PingppResponse(responseCode, responseBody, headers);
            return pingppResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Pingpp (%s): %s Please check your internet connection and try again.", Pingpp.getApiBase(), e.getMessage()), e);
        }
        catch (AuthenticationException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    static HttpHeaders getHeaders(PingppRequest request) {
        HashMap<String, List<String>> userAgentHeadersMap = new HashMap<String, List<String>>();
        userAgentHeadersMap.put("User-Agent", Collections.singletonList(HttpURLConnectionClient.buildUserAgentString()));
        userAgentHeadersMap.put("X-Pingpp-Client-User-Agent", Collections.singletonList(HttpURLConnectionClient.buildXPingppClientUserAgentString()));
        return request.getHeaders().withAdditionalHeaders(userAgentHeadersMap);
    }

    private static HttpURLConnection createPingppConnection(PingppRequest request) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)request.url.openConnection();
        conn.setConnectTimeout(request.options.getConnectTimeout());
        conn.setReadTimeout(request.options.getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, List<String>> entry : HttpURLConnectionClient.getHeaders(request).map().entrySet()) {
            conn.setRequestProperty(entry.getKey(), StringUtils.join(",", entry.getValue()));
        }
        conn.setRequestMethod(request.method.name());
        String requestTime = HttpURLConnectionClient.currentTimeString();
        conn.setRequestProperty("Pingplusplus-Request-Timestamp", requestTime);
        String signature = HttpURLConnectionClient.buildPingppSignature(request, requestTime);
        if (signature != null) {
            conn.setRequestProperty("Pingplusplus-Signature", signature);
        }
        if (request.content != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.content.contentType);
            try (OutputStream output = conn.getOutputStream();){
                output.write(request.content.byteArrayContent);
            }
        }
        return conn;
    }
}

