/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.pingplusplus.Pingpp;

public class RequestOptions {
    private final String apiKey;
    private final String appId;
    private final String privateKey;
    private final String verifyPublicKey;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxNetworkRetries;
    private final String acceptLanguage;

    public static RequestOptions getDefault() {
        return new RequestOptions(Pingpp.apiKey, Pingpp.appId, Pingpp.privateKey, Pingpp.verifyPublicKey, Pingpp.getConnectTimeout(), Pingpp.getReadTimeout(), Pingpp.getMaxNetworkRetries(), Pingpp.getAcceptLanguage());
    }

    private RequestOptions(String apiKey, String appId, String privateKey, String verifyPublicKey, int connectTimeout, int readTimeout, int maxNetworkRetries, String acceptLanguage) {
        this.apiKey = apiKey;
        this.appId = appId;
        this.privateKey = privateKey;
        this.verifyPublicKey = verifyPublicKey;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.acceptLanguage = acceptLanguage;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getVerifyPublicKey() {
        return this.verifyPublicKey;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeAppId(String appId) {
        if (appId == null) {
            return null;
        }
        String normalized = appId.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty app_id specified!");
        }
        return normalized;
    }

    private static String normalizePrivateKey(String privateKey) {
        if (privateKey == null) {
            return null;
        }
        String normalized = privateKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty privateKey specified!");
        }
        return normalized;
    }

    private static String normalizePublicVerifyKey(String verifyPublicKey) {
        if (verifyPublicKey == null) {
            return null;
        }
        String normalized = verifyPublicKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty publicVerifyKey specified!");
        }
        return normalized;
    }

    private static String normalizeAcceptLanguage(String acceptLanguage) {
        if (acceptLanguage == null) {
            return null;
        }
        String normalized = acceptLanguage.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Accept-Language specified!");
        }
        return normalized;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Pingpp.apiKey;
        private String appId = Pingpp.appId;
        private String privateKey = Pingpp.privateKey;
        private int connectTimeout = Pingpp.getConnectTimeout();
        private int readTimeout = Pingpp.getReadTimeout();
        private int maxNetworkRetries = Pingpp.getMaxNetworkRetries();
        private String acceptLanguage = Pingpp.getAcceptLanguage();
        private String verifyPublicKey;

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public String getAppId() {
            return this.appId;
        }

        public RequestOptionsBuilder setAppId(String appId) {
            this.appId = RequestOptions.normalizeAppId(appId);
            return this;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public RequestOptionsBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public RequestOptionsBuilder clearAppId() {
            this.appId = null;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptionsBuilder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptionsBuilder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public int getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        public RequestOptionsBuilder setMaxNetworkRetries(int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public RequestOptionsBuilder setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = RequestOptions.normalizeAcceptLanguage(acceptLanguage);
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeAppId(this.appId), RequestOptions.normalizePrivateKey(this.privateKey), RequestOptions.normalizePublicVerifyKey(this.verifyPublicKey), this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.acceptLanguage);
        }
    }
}

