/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.pingplusplus.model.App;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.serializer.ChargeRefundCollectionDeserializer;
import com.pingplusplus.util.GsonUtils;
import java.lang.reflect.Type;

public class ChargeDeserializer
implements JsonDeserializer<Charge> {
    public Charge deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject chargeJson = jsonElement.getAsJsonObject();
        if (null != chargeJson.getAsJsonObject("credential")) {
            long timeStamp;
            JsonObject credentialJson = chargeJson.getAsJsonObject("credential");
            if (credentialJson.getAsJsonObject("wx") != null) {
                JsonObject wx = credentialJson.getAsJsonObject("wx");
                timeStamp = wx.get("timeStamp").getAsLong();
                wx.addProperty("timeStamp", Long.toString(timeStamp));
            } else if (credentialJson.getAsJsonObject("wx_pub") != null) {
                JsonObject wxPub = credentialJson.getAsJsonObject("wx_pub");
                if (null == wxPub.get("signed_data") && wxPub.get("timeStamp") != null) {
                    timeStamp = wxPub.get("timeStamp").getAsLong();
                    wxPub.addProperty("timeStamp", Long.toString(timeStamp));
                }
            } else {
                JsonObject channelCredential = credentialJson.getAsJsonObject("bfb");
                if (channelCredential != null || (channelCredential = credentialJson.getAsJsonObject("bfb_wap")) != null) {
                    if (channelCredential.has("total_amount")) {
                        long total_amount = channelCredential.get("total_amount").getAsLong();
                        channelCredential.addProperty("total_amount", Long.toString(total_amount));
                    }
                } else {
                    channelCredential = credentialJson.getAsJsonObject("alipay");
                    if ((channelCredential != null || (channelCredential = credentialJson.getAsJsonObject("alipay_wap")) != null || (channelCredential = credentialJson.getAsJsonObject("alipay_pc_direct")) != null) && channelCredential.has("payment_type")) {
                        long paymentType = channelCredential.get("payment_type").getAsLong();
                        channelCredential.addProperty("payment_type", Long.toString(paymentType));
                    }
                }
            }
        }
        Gson gson = GsonUtils.baseGsonBuilder().registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).create();
        JsonElement appElement = chargeJson.get("app");
        Charge charge = (Charge)gson.fromJson(jsonElement, Charge.class);
        if (null != appElement && appElement.isJsonObject()) {
            App app = (App)gson.fromJson(appElement, App.class);
            charge.setApp(app);
        }
        return charge;
    }
}

