/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.util.WxpubOAuth;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class WxLiteOAuth
extends WxpubOAuth {
    public static String getOpenId(String appId, String appSecret, String code) throws UnsupportedEncodingException, ChannelException {
        AuthResult authResult = WxLiteOAuth.getSession(appId, appSecret, code);
        if (authResult.getErrmsg() != null) {
            throw new ChannelException(authResult.getErrmsg(), null, null, authResult.getErrcode().toString(), 0, null);
        }
        return authResult.getOpenid();
    }

    public static AuthResult getSession(String appId, String appSecret, String code) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", appId);
        params.put("secret", appSecret);
        params.put("js_code", code);
        params.put("grant_type", "authorization_code");
        String url = "https://api.weixin.qq.com/sns/jscode2session?" + WxLiteOAuth.httpBuildQuery(params);
        String ret = WxLiteOAuth.httpGet(url);
        return (AuthResult)new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create().fromJson(ret, AuthResult.class);
    }

    public static class AuthResult {
        String sessionKey;
        String openid;
        String unionid;
        Integer errcode;
        String errmsg;

        public String getSessionKey() {
            return this.sessionKey;
        }

        public String getOpenid() {
            return this.openid;
        }

        public String getUnionid() {
            return this.unionid;
        }

        public Integer getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }
    }
}

