/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.pingplusplus.util.GsonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ObjectListDeserializer
implements JsonDeserializer<List<Object>> {
    public List<Object> deserialize(JsonElement elem, Type type, JsonDeserializationContext context) {
        ArrayList<Object> list = new ArrayList<Object>();
        JsonArray jsonArray = elem.getAsJsonArray();
        for (JsonElement element : jsonArray) {
            if (element.isJsonNull()) {
                list.add(null);
                continue;
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    String numStr = primitive.getAsString();
                    if (numStr.contains(".")) {
                        list.add(primitive.getAsDouble());
                        continue;
                    }
                    try {
                        list.add(primitive.getAsLong());
                    }
                    catch (NumberFormatException e) {
                        list.add(primitive.getAsBigDecimal());
                    }
                    continue;
                }
                if (primitive.isString()) {
                    list.add(primitive.getAsString());
                    continue;
                }
                if (!primitive.isBoolean()) continue;
                list.add(primitive.getAsBoolean());
                continue;
            }
            if (element.isJsonArray()) {
                list.add(context.deserialize(element, GsonUtils.LIST_OBJ));
                continue;
            }
            if (!element.isJsonObject()) continue;
            list.add(context.deserialize(element, GsonUtils.MAP_STR_OBJ));
        }
        return list;
    }
}

