/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.pingplusplus.util.GsonUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class StringObjectMapDeserializer
implements JsonDeserializer<Map<String, Object>> {
    public Map<String, Object> deserialize(JsonElement elem, Type type, JsonDeserializationContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JsonObject jsonObject = elem.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonNull()) {
                map.put(key, null);
                continue;
            }
            if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    String numStr = primitive.getAsString();
                    if (numStr.contains(".")) {
                        map.put(key, primitive.getAsDouble());
                        continue;
                    }
                    try {
                        map.put(key, primitive.getAsLong());
                    }
                    catch (NumberFormatException e) {
                        map.put(key, primitive.getAsBigDecimal());
                    }
                    continue;
                }
                if (primitive.isString()) {
                    map.put(key, primitive.getAsString());
                    continue;
                }
                if (!primitive.isBoolean()) continue;
                map.put(key, primitive.getAsBoolean());
                continue;
            }
            if (value.isJsonArray()) {
                map.put(key, context.deserialize(value, GsonUtils.LIST_OBJ));
                continue;
            }
            if (!value.isJsonObject()) continue;
            map.put(key, context.deserialize(value, GsonUtils.MAP_STR_OBJ));
        }
        return map;
    }
}

