/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor;

import fr.weefle.constructor.SchematicBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    private String schematicsFolder;
    private final List<Material> markMats = new ArrayList<Material>();
    private double moveTimeoutTicks;
    private boolean ignoreProtection;
    private boolean holdItems;
    private boolean requireMaterials;
    private String startedMessage;
    private String completeMessage;
    private String cancelMessage;
    private String markMessage;
    private String surveyMessage;
    private String supplyListMessage;
    private String supplyNeedMessage;
    private String supplyDontNeedMessage;
    private String supplyTakenMessage;
    private String collectingMessage;

    public Config() {
        this.reload();
    }

    public void reload() {
        SchematicBuilder plugin = SchematicBuilder.getInstance();
        plugin.saveDefaultConfig();
        plugin.reloadConfig();
        FileConfiguration config = plugin.getConfig();
        this.schematicsFolder = config.getString("SchematicsFolder", plugin.getDataFolder() + File.separator + "schematics" + File.separator);
        this.moveTimeoutTicks = config.getDouble("DefaultOptions.MoveTimeoutSeconds", 1.0);
        this.ignoreProtection = config.getBoolean("DefaultOptions.IgnoreProtection");
        this.holdItems = config.getBoolean("DefaultOptions.HoldItems");
        this.requireMaterials = config.getBoolean("DefaultOptions.RequireMaterials");
        this.completeMessage = config.getString("DefaultTexts.BuildComplete", "");
        this.cancelMessage = config.getString("DefaultTexts.BuildCanceled", "");
        this.startedMessage = config.getString("DefaultTexts.BuildStarted", "");
        this.collectingMessage = config.getString("DefaultTexts.BuildCollecting", "");
        this.markMessage = config.getString("DefaultTexts.Mark", "");
        this.surveyMessage = config.getString("DefaultTexts.Survey", "");
        this.supplyListMessage = config.getString("DefaultTexts.Supply_List", "");
        this.supplyNeedMessage = config.getString("DefaultTexts.Supply_Need_Item", "");
        this.supplyDontNeedMessage = config.getString("DefaultTexts.Supply_Dont_Need_Item", "");
        this.supplyTakenMessage = config.getString("DefaultTexts.Supply_Item_Taken", "");
        for (String material : config.getStringList("MarkMaterials")) {
            this.markMats.add(Material.valueOf((String)material));
        }
        if (this.markMats.isEmpty()) {
            this.markMats.add(Material.GLASS);
        }
    }

    public String getSchematicsFolder() {
        return this.schematicsFolder;
    }

    public List<Material> getMarkMats() {
        return this.markMats;
    }

    public double getMoveTimeoutTicks() {
        return this.moveTimeoutTicks;
    }

    public boolean isIgnoreProtection() {
        return this.ignoreProtection;
    }

    public boolean isHoldItems() {
        return this.holdItems;
    }

    public boolean isRequireMaterials() {
        return this.requireMaterials;
    }

    public String getStartedMessage() {
        return this.startedMessage;
    }

    public String getCompleteMessage() {
        return this.completeMessage;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public String getMarkMessage() {
        return this.markMessage;
    }

    public String getSurveyMessage() {
        return this.surveyMessage;
    }

    public String getSupplyListMessage() {
        return this.supplyListMessage;
    }

    public String getSupplyNeedMessage() {
        return this.supplyNeedMessage;
    }

    public String getSupplyDontNeedMessage() {
        return this.supplyDontNeedMessage;
    }

    public String getSupplyTakenMessage() {
        return this.supplyTakenMessage;
    }

    public String getCollectingMessage() {
        return this.collectingMessage;
    }
}

