/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor;

import fr.weefle.constructor.SchematicBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Updater
extends Thread {
    private int id;
    public static boolean update = false;
    private boolean log = false;
    private boolean enabled = true;
    public static boolean enabledingame = true;
    private URL url;
    private final SchematicBuilder m;

    public Updater(SchematicBuilder m) {
        this.m = m;
    }

    public Updater(SchematicBuilder plugin, int resourceID) throws IOException {
        this(plugin, resourceID, true);
    }

    public Updater(SchematicBuilder plugin, int resourceID, boolean log) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        if (resourceID == 0) {
            throw new IllegalArgumentException("Resource ID cannot be null (0)");
        }
        this.m = plugin;
        this.id = resourceID;
        this.log = log;
        this.url = new URL("https://pastebin.com/raw/MT8GTJNY");
        File configDir = new File(plugin.getDataFolder().getParentFile(), "ProSchematicBuilder");
        File config = new File(configDir, "updater.yml");
        YamlConfiguration yamlConfig = new YamlConfiguration();
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!config.exists()) {
            config.createNewFile();
            yamlConfig.options().header("Configuration for the ProSchematicBuilder updater system\nit will inform you about new versions of all plugins which use this updater\n'enabled' specifies whether the system is enabled (affects all plugins)");
            yamlConfig.options().copyDefaults(true);
            yamlConfig.addDefault("enabled", (Object)true);
            yamlConfig.addDefault("enabledingame", (Object)true);
            yamlConfig.save(config);
        }
        try {
            yamlConfig.load(config);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
            return;
        }
        this.enabled = yamlConfig.getBoolean("enabled");
        enabledingame = yamlConfig.getBoolean("enabledingame");
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public void run() {
        block17: {
            if (!this.m.isEnabled()) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            if (this.log) {
                this.m.getLogger().info("[Updater] Searching for updates.");
            }
            HttpURLConnection connection = null;
            try {
                String version;
                connection = (HttpURLConnection)this.url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
                connection.setRequestMethod("GET");
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String content = "";
                String line = null;
                while ((line = in.readLine()) != null) {
                    content = content + line;
                }
                in.close();
                JSONObject json = null;
                try {
                    json = (JSONObject)new JSONParser().parse(content);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                String currentVersion = null;
                if (json != null && json.containsKey((Object)"name") && (version = (String)json.get((Object)"name")) != null && !version.isEmpty()) {
                    currentVersion = version;
                }
                if (currentVersion == null) {
                    if (this.log) {
                        this.m.getLogger().warning("[Updater] Invalid response received.");
                        this.m.getLogger().warning("[Updater] Either the author of this plugin has configured the updater wrong, or the API is experiencing some issues.");
                    }
                    return;
                }
                if (!currentVersion.equals(this.m.getDescription().getVersion())) {
                    this.m.getLogger().info("[Updater] Found new version: " + currentVersion + "! (Your version is " + this.m.getDescription().getVersion() + ")");
                    this.m.getLogger().info("[Updater] Download here: http://www.spigotmc.org/resources/" + this.id);
                    update = true;
                } else if (this.log) {
                    this.m.getLogger().info("[Updater] Plugin is up-to-date.");
                }
            }
            catch (IOException e) {
                if (!this.log) break block17;
                if (connection != null) {
                    try {
                        int code = connection.getResponseCode();
                        this.m.getLogger().warning("[Updater] API connection returned response code " + code);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                e.printStackTrace();
            }
        }
    }
}

