/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.SchematicBuilder;
import fr.weefle.constructor.commands.HyphenArgument;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommand
implements CommandExecutor,
TabCompleter {
    protected final String command;
    protected final String description;
    protected final AbstractCommand parent;
    protected final Map<String, AbstractCommand> subCommands = new HashMap<String, AbstractCommand>();
    protected final Set<Class<? extends CommandSender>> allowedSenders = new HashSet<Class<? extends CommandSender>>();
    protected final Map<String, HyphenArgument> hyphenArguments = new HashMap<String, HyphenArgument>();
    protected String permission;

    public AbstractCommand(@NotNull String command, @Nullable String description, @Nullable AbstractCommand parent) {
        this.command = command;
        this.description = description;
        this.parent = parent;
    }

    public AbstractCommand(@NotNull String command, @Nullable String description) {
        this(command, description, null);
    }

    public AbstractCommand(@NotNull String command, @Nullable AbstractCommand parent) {
        this(command, null, parent);
    }

    public final String getCommand() {
        return this.command;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getFullCommand() {
        return this.parent == null ? this.command + " [id]" : this.parent.getFullCommand() + ' ' + this.command;
    }

    protected final void registerSubCommand(AbstractCommand subCommand) {
        this.subCommands.put(subCommand.getCommand(), subCommand);
    }

    protected final void registerHyphenArgument(HyphenArgument hyphenArgument) {
        this.hyphenArguments.put(hyphenArgument.getName(), hyphenArgument);
    }

    protected final void addAllowedSender(Class<? extends CommandSender> senderClass) {
        this.allowedSenders.add(senderClass);
    }

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        AbstractCommand subCommand;
        boolean validSender = false;
        if (this.allowedSenders.isEmpty()) {
            validSender = true;
        } else {
            for (Class<? extends CommandSender> allowedSender : this.allowedSenders) {
                if (!allowedSender.isAssignableFrom(sender.getClass())) continue;
                validSender = true;
                break;
            }
        }
        if (!validSender) {
            sender.sendMessage(ChatColor.RED + "Command not runnable from here.");
            return true;
        }
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            sender.sendMessage(ChatColor.RED + "You lack the permission \"" + this.permission + "\" to run that command.");
            return true;
        }
        ArrayList<String> arguments = new ArrayList<String>(args.length);
        arguments.addAll(Arrays.asList(args));
        if (arguments.size() != 0) {
            try {
                int id = Integer.parseInt((String)arguments.get(0));
                NPC npc = CitizensAPI.getNPCRegistry().getById(id);
                arguments.remove(0);
                if (npc == null) {
                    sender.sendMessage(ChatColor.RED + "No NPC with id " + id + " found.");
                    return true;
                }
                CitizensAPI.getDefaultNPCSelector().select(sender, npc);
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        if (args.length > 0 && (subCommand = this.subCommands.get(arguments.get(0))) != null) {
            arguments.remove(0);
            subCommand.onCommand(sender, command, label, arguments.toArray(new String[0]));
            return true;
        }
        this.execute(sender, command, label, arguments);
        return true;
    }

    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        this.sendUsage(sender);
    }

    public List<String> getArguments(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, AbstractCommand> entry : this.subCommands.entrySet()) {
            String permission = entry.getValue().getPermission();
            if (permission != null && !sender.hasPermission(permission)) continue;
            list.add(entry.getKey());
        }
        for (HyphenArgument hyphenArgument : this.hyphenArguments.values()) {
            list.add(hyphenArgument.getName());
        }
        return list;
    }

    public List<String> getUsages(CommandSender sender) {
        ArrayList<String> usages;
        List<String> arguments = this.getArguments(sender);
        if (arguments.isEmpty()) {
            usages = new ArrayList<String>(1);
            usages.add('/' + this.getFullCommand());
        } else {
            ArrayList regularArguments = new ArrayList();
            ArrayList<String> optionalArguments = new ArrayList<String>();
            for (String argument : arguments) {
                (argument.startsWith("-") ? optionalArguments : regularArguments).add(argument);
            }
            usages = new ArrayList(arguments.size());
            for (String argument : regularArguments) {
                StringBuilder builder = new StringBuilder('/' + this.getFullCommand() + ' ' + argument);
                for (String optionalArgument : optionalArguments) {
                    builder.append(' ').append(optionalArgument);
                    if (!optionalArgument.endsWith("=")) continue;
                    builder.append('<').append(optionalArgument).append('>');
                }
                usages.add(builder.toString());
            }
        }
        return usages;
    }

    public final void sendUsage(@NotNull CommandSender sender) {
        List<String> usages = this.getUsages(sender);
        if (usages.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "Incorrect command syntax");
        } else {
            sender.sendMessage("Command info:");
            for (String usage : usages) {
                sender.sendMessage("  " + usage);
            }
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String beforeLast;
        HyphenArgument hyphenArgument;
        if (args.length == 0) {
            return this.getArguments(sender);
        }
        AbstractCommand subcommand = this.subCommands.get(args[0]);
        if (subcommand != null) {
            return subcommand.onTabComplete(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        }
        if (args.length > 1 && (hyphenArgument = this.hyphenArguments.get(beforeLast = args[args.length - 2])) != null) {
            ArrayList<String> completions = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[args.length - 1], hyphenArgument.getArguments(), completions);
            return completions;
        }
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)args[args.length - 1], this.getArguments(sender), completions);
        StringUtil.copyPartialMatches((String)args[args.length - 1], this.hyphenArguments.keySet(), completions);
        int lastIndex = args.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            String arg = args[i];
            completions.removeIf(arg::startsWith);
        }
        return completions;
    }

    @Nullable
    protected BuilderTrait getSelectedBuilder(CommandSender sender) {
        Owner ownerTrait;
        NPC npc = CitizensAPI.getDefaultNPCSelector().getSelected(sender);
        if (npc == null) {
            sender.sendMessage(ChatColor.RED + "You must have a NPC selected to use this command");
            return null;
        }
        BuilderTrait builderTrait = SchematicBuilder.getBuilder(npc);
        if (builderTrait == null) {
            sender.sendMessage(ChatColor.RED + "The selected NPC is not a builder");
            return null;
        }
        if (!(sender instanceof ConsoleCommandSender || sender.hasPermission("citizens.admin") || (ownerTrait = (Owner)npc.getTraitNullable(Owner.class)) == null || sender instanceof Entity && ((Entity)sender).getUniqueId().equals(ownerTrait.getOwnerId()))) {
            sender.sendMessage(ChatColor.RED + "You must be the owner of this NPC to execute this command");
            return null;
        }
        return builderTrait;
    }

    protected Map<String, String> getHyphenArguments(List<String> args) {
        HashMap<String, String> map = new HashMap<String, String>();
        int last = args.size() - 1;
        for (int i = 0; i < last; ++i) {
            String arg = args.get(i);
            if (!this.hyphenArguments.keySet().stream().anyMatch(arg::equalsIgnoreCase)) continue;
            map.put(arg, args.get(i + 1));
        }
        return map;
    }
}

