/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.HyphenArgument;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildSubCommand
extends AbstractCommand {
    public BuildSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("build", "Begin building with the selected options", parent);
        this.permission = "schematicbuilder.build";
        this.registerHyphenArgument(new HyphenArgument("silent", "true", "false"));
        this.registerHyphenArgument(new HyphenArgument("onComplete", new String[0]));
        this.registerHyphenArgument(new HyphenArgument("onCancel", new String[0]));
        this.registerHyphenArgument(new HyphenArgument("onStart", new String[0]));
        this.registerHyphenArgument(new HyphenArgument("layers", new String[0]));
        this.registerHyphenArgument(new HyphenArgument("yOffset", new String[0]));
        this.registerHyphenArgument(new HyphenArgument("groupAll", "true", "false"));
        this.registerHyphenArgument(new HyphenArgument("ignoreAir", "true", "false"));
        this.registerHyphenArgument(new HyphenArgument("ignoreLiquid", "true", "false"));
        this.registerHyphenArgument(new HyphenArgument("excavate", "true", "false"));
        this.registerHyphenArgument(new HyphenArgument("buildPatternXZ", "spiral", "reverse_spiral", "linear", "reverse_linear"));
        this.registerHyphenArgument(new HyphenArgument("offset", "true", "false"));
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        NPC npc = builder.getNPC();
        if (builder.getState() == BuilderTrait.BuilderState.BUILDING) {
            if (!builder.isSilent()) {
                sender.sendMessage(ChatColor.RED + npc.getName() + " is already building");
            }
            return;
        }
        for (Map.Entry<String, String> entry : this.getHyphenArguments(args).entrySet()) {
            String arg = entry.getKey();
            String value = entry.getValue();
            if (arg.equalsIgnoreCase("silent")) {
                builder.setSilent(Boolean.parseBoolean(value));
                continue;
            }
            if (arg.equalsIgnoreCase("onComplete")) {
                builder.setOnComplete(value);
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " will run task " + value + " on build completion");
                continue;
            }
            if (arg.equalsIgnoreCase("onCancel")) {
                builder.setOnCancel(value);
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " will run task " + value + " on build cancellation");
                continue;
            }
            if (arg.equalsIgnoreCase("onStart")) {
                builder.setOnStart(value);
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " will run task " + value + " on build start");
                continue;
            }
            if (arg.equalsIgnoreCase("layers")) {
                int layers;
                try {
                    layers = Integer.parseInt(value);
                    if (layers < 1) {
                        sender.sendMessage(ChatColor.RED + "Number of layers must me positive");
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.RED + arg + " is not a valid number of layers");
                    return;
                }
                builder.setBuildYLayers(layers);
                continue;
            }
            if (arg.equalsIgnoreCase("groupAll")) {
                builder.GroupByLayer = true;
                continue;
            }
            if (arg.equalsIgnoreCase("ignoreAir")) {
                builder.setIgnoreAir(Boolean.parseBoolean(value));
                continue;
            }
            if (arg.equalsIgnoreCase("ignoreLiquid")) {
                builder.setIgnoreLiquids(Boolean.parseBoolean(value));
                continue;
            }
            if (arg.equalsIgnoreCase("excavate")) {
                builder.setExcavate(Boolean.parseBoolean(value));
                if (builder.isSilent()) continue;
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " will excavate first");
                continue;
            }
            if (!arg.equalsIgnoreCase("buildPatternXZ")) continue;
            try {
                builder.setBuildPatternXZ(BuilderTrait.BuildPatternXZ.valueOf(entry.getValue().toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(ChatColor.RED + arg + " is not a valid buildPatternXZ");
            }
        }
        builder.TryBuild(sender);
    }
}

