/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.SchematicBuilder;
import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CancelSubCommand
extends AbstractCommand {
    public CancelSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("cancel", "Cancel building", parent);
        this.permission = "schematicbuilder.cancel";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        if (args.size() != 0) {
            this.sendUsage(sender);
            return;
        }
        NPC npc = builder.getNPC();
        if (builder.getState() != BuilderTrait.BuilderState.IDLE) {
            sender.sendMessage(SchematicBuilder.format(SchematicBuilder.getInstance().config().getCancelMessage(), npc, builder.getSchematic(), sender, null, "0"));
        } else {
            sender.sendMessage(ChatColor.RED + npc.getName() + " is not building.");
        }
        builder.CancelBuild();
    }
}

