/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcavatedSubCommand
extends AbstractCommand {
    public ExcavatedSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("excavated", "Get all excavated blocks from current build", parent);
        this.permission = "schematicbuilder.excavated";
        this.addAllowedSender(Player.class);
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        if (args.size() != 0) {
            this.sendUsage(sender);
            return;
        }
        NPC npc = builder.getNPC();
        if (builder.getState() == BuilderTrait.BuilderState.BUILDING && builder.isExcavate()) {
            if (!builder.ExcavateMaterials.isEmpty()) {
                PlayerInventory inventory = ((Player)sender).getInventory();
                for (Map.Entry<Material, Integer> entry : builder.ExcavateMaterials.entrySet()) {
                    int amount;
                    for (int total = entry.getValue().intValue(); total > 0; total -= amount) {
                        amount = Math.min(total, 64);
                        inventory.addItem(new ItemStack[]{new ItemStack(entry.getKey(), amount)});
                    }
                }
                builder.ExcavateMaterials.clear();
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " gave you all excavated blocks");
            } else {
                sender.sendMessage(ChatColor.RED + npc.getName() + " has no excavated blocks");
            }
        } else {
            sender.sendMessage(ChatColor.RED + npc.getName() + " is not currently building");
        }
    }
}

