/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoldSubCommand
extends AbstractCommand {
    public HoldSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("hold", "Set whether the Constructor holds blocks while building", parent);
        this.permission = "schematicbuilder.hold";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        boolean holdItems;
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        NPC npc = builder.getNPC();
        if (args.size() == 0) {
            sender.sendMessage(ChatColor.GOLD + npc.getName() + " currently does" + (builder.isHoldItems() ? "" : " NOT") + " hold blocks.");
            return;
        }
        if (args.size() != 1) {
            this.sendUsage(sender);
            return;
        }
        try {
            holdItems = Boolean.parseBoolean(args.get(0));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + args.get(0) + " is not a valid boolean");
            return;
        }
        builder.setHoldItems(holdItems);
        sender.sendMessage(ChatColor.GOLD + npc.getName() + " now does" + (holdItems ? "" : " NOT") + " hold blocks.");
    }
}

