/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.SchematicBuilder;
import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import fr.weefle.constructor.schematic.Schematic;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadSubCommand
extends AbstractCommand {
    public LoadSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("load", "Loads a schematic file", parent);
        this.permission = "schematicbuilder.load";
    }

    @Override
    public List<String> getArguments(CommandSender sender) {
        ArrayList<String> files = new ArrayList<String>();
        try {
            Path dir = new File(SchematicBuilder.getInstance().config().getSchematicsFolder()).toPath();
            Files.walk(dir, new FileVisitOption[0]).forEach(path -> {
                String stringPath = path.toString();
                if (path.toFile().isFile() && (stringPath.endsWith(".schem") || stringPath.endsWith(".nbt") || stringPath.endsWith(".yml"))) {
                    files.add(dir.relativize((Path)path).toString());
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    @Override
    public List<String> getUsages(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        list.add('/' + this.getFullCommand() + " <schematic>");
        return list;
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return this.getArguments(sender);
        }
        StringBuilder stringBuilder = new StringBuilder(args[0]);
        for (int i = 1; i < args.length; ++i) {
            stringBuilder.append(" ").append(args[i]);
        }
        String arg = stringBuilder.toString();
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)stringBuilder.toString().trim(), this.getArguments(sender), completions);
        completions.removeIf(arg::startsWith);
        return completions;
    }

    @Override
    public void execute(final @NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        final BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        if (args.size() == 0) {
            this.sendUsage(sender);
            return;
        }
        if (builder.getState() != BuilderTrait.BuilderState.IDLE) {
            sender.sendMessage(ChatColor.RED + "Please cancel current build before loading new schematic.");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(args.get(0));
        for (int i = 1; i < args.size(); ++i) {
            stringBuilder.append(" ").append(args.get(i));
        }
        final String arg = stringBuilder.toString().trim();
        new BukkitRunnable(){

            public void run() {
                try {
                    final Schematic schematic = SchematicBuilder.getSchematic(arg);
                    new BukkitRunnable(){

                        public void run() {
                            if (schematic == null) {
                                sender.sendMessage(ChatColor.RED + "no such file " + arg);
                            } else {
                                builder.setSchematic(schematic);
                                sender.sendMessage(ChatColor.GREEN + "Loaded Sucessfully");
                                sender.sendMessage(schematic.getInfo());
                            }
                        }
                    }.runTask((Plugin)SchematicBuilder.getInstance());
                }
                catch (Exception e) {
                    new BukkitRunnable(){

                        public void run() {
                            sender.sendMessage(ChatColor.RED + "Failed to load schematic " + arg + ", check console for more details.");
                            SchematicBuilder.getInstance().getLogger().log(Level.WARNING, "Failed to load schematic: " + arg);
                            e.printStackTrace();
                        }
                    }.runTask((Plugin)SchematicBuilder.getInstance());
                }
            }
        }.runTaskAsynchronously((Plugin)SchematicBuilder.getInstance());
    }
}

