/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import fr.weefle.constructor.schematic.Schematic;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginSubCommand
extends AbstractCommand {
    public OriginSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("origin", "Sets the build origin", parent);
        this.permission = "schematicbuilder.origin";
        this.addAllowedSender(Player.class);
        this.registerSubCommand(new AbstractCommand("clear", (AbstractCommand)this){

            @Override
            public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
                BuilderTrait builder = this.getSelectedBuilder(sender);
                if (builder == null) {
                    return;
                }
                builder.setOrigin(null);
                sender.sendMessage(ChatColor.GREEN + builder.getNPC().getName() + " build origin has been cleared");
            }
        });
        this.registerSubCommand(new AbstractCommand("schematic", (AbstractCommand)this){

            @Override
            public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
                BuilderTrait builder = this.getSelectedBuilder(sender);
                if (builder == null) {
                    return;
                }
                NPC npc = builder.getNPC();
                Schematic schematic = builder.getSchematic();
                if (schematic == null) {
                    sender.sendMessage(ChatColor.RED + npc.getName() + " has no schematic loaded");
                    return;
                }
                Vector absolutePosition = schematic.getAbsolutePosition();
                if (absolutePosition == null) {
                    sender.sendMessage(schematic.getDisplayName() + ChatColor.RED + " has no origin data");
                    return;
                }
                builder.setOrigin(absolutePosition.toLocation(builder.getNPC().getEntity().getWorld()));
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " build origin has been set to:" + ChatColor.WHITE + builder.getOrigin());
            }
        });
        this.registerSubCommand(new AbstractCommand("me", (AbstractCommand)this){

            @Override
            public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
                BuilderTrait builder = this.getSelectedBuilder(sender);
                if (builder == null) {
                    return;
                }
                NPC npc = builder.getNPC();
                builder.setOrigin(((Player)sender).getLocation());
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " build origin has been set to your location");
            }
        });
        this.registerSubCommand(new AbstractCommand("current", (AbstractCommand)this){

            @Override
            public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
                BuilderTrait builder = this.getSelectedBuilder(sender);
                if (builder == null) {
                    return;
                }
                NPC npc = builder.getNPC();
                if (builder.getState() == BuilderTrait.BuilderState.BUILDING) {
                    builder.setOrigin(builder.getContinueLoc());
                    sender.sendMessage(ChatColor.GREEN + npc.getName() + " build origin has been set to the origin of the current build");
                } else {
                    sender.sendMessage(ChatColor.RED + npc.getName() + " is not currently building!");
                }
            }
        });
    }

    @Override
    public List<String> getUsages(CommandSender sender) {
        List<String> list = super.getUsages(sender);
        list.add(0, '/' + this.getFullCommand());
        list.add('/' + this.getFullCommand() + " <x>,<y>,<z>");
        return list;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        NPC npc = builder.getNPC();
        if (args.size() <= 0) {
            if (builder.getNPC().isSpawned()) {
                builder.setOrigin(builder.getNPC().getEntity().getLocation());
                sender.sendMessage(ChatColor.GREEN + npc.getName() + " build origin has been set to its current location.");
            } else {
                sender.sendMessage(ChatColor.RED + npc.getName() + " not spawned.");
            }
        } else {
            String[] coordinates = args.get(0).split(",");
            if (coordinates.length == 3) {
                try {
                    int x = Integer.parseInt(coordinates[0]);
                    int y = Integer.parseInt(coordinates[1]);
                    int z = Integer.parseInt(coordinates[2]);
                    builder.setOrigin(new Location(builder.getNPC().getEntity().getWorld(), (double)x, (double)y, (double)z));
                    sender.sendMessage(ChatColor.GREEN + npc.getName() + " build origin has been set to " + ChatColor.WHITE + builder.getOrigin());
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.RED + "Invalid Coordinates");
                }
            } else {
                AbstractCommand subCommand = (AbstractCommand)this.subCommands.get(args.remove(0));
                if (subCommand == null) {
                    this.sendUsage(sender);
                } else {
                    subCommand.onCommand(sender, command, label, args.toArray(new String[0]));
                }
            }
        }
    }
}

