/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import fr.weefle.constructor.schematic.Schematic;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewSubCommand
extends AbstractCommand {
    public PreviewSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("preview", "Shows the preview of the current structure", parent);
        this.permission = "schematicbuilder.preview";
        this.addAllowedSender(Player.class);
    }

    @Override
    public List<String> getUsages(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        list.add('/' + this.getFullCommand() + " [ticks]");
        return list;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        int ticks;
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        if (args.size() == 1) {
            try {
                ticks = Integer.parseInt(args.get(0));
            }
            catch (NumberFormatException e) {
                sender.sendMessage(args.get(0) + ChatColor.RED + " is not a valid number");
                return;
            }
        } else if (args.size() == 0) {
            ticks = 1000;
        } else {
            this.sendUsage(sender);
            return;
        }
        NPC npc = builder.getNPC();
        Player player = (Player)sender;
        Location tmpLoc = npc.getEntity().getLocation();
        switch (builder.getState()) {
            case IDLE: 
            case COLLECTING: {
                Schematic schematic = builder.getSchematic();
                if (schematic == null) {
                    sender.sendMessage(ChatColor.RED + "No Schematic Loaded");
                    return;
                }
                schematic.preview(builder, (Player)sender, ticks);
                player.sendMessage(npc.getName() + ChatColor.GREEN + " loaded a preview of the current structure");
                break;
            }
            default: {
                player.sendMessage(npc.getName() + ChatColor.RED + " can't load a preview right now");
            }
        }
    }
}

