/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.api.StructureUtil;
import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.listener.SelectionListener;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureSubCommand
extends AbstractCommand {
    public StructureSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("structure", "Save named structure with WorldEdit region selection", parent);
        this.permission = "schematicbuilder.structure";
        this.addAllowedSender(Player.class);
    }

    @Override
    public List<String> getUsages(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        list.add('/' + this.getFullCommand() + " <name>");
        return list;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        Vector vec;
        if (args.size() != 1) {
            this.sendUsage(sender);
            return;
        }
        Player player = (Player)sender;
        String name = args.get(0);
        try {
            vec = SelectionListener.vector.get(player);
        }
        catch (NullPointerException e) {
            player.sendMessage(ChatColor.RED + "You have not selected any region!");
            return;
        }
        try {
            StructureUtil.save(SelectionListener.location.get(player), vec, name);
        }
        catch (NullPointerException e) {
            player.sendMessage(ChatColor.RED + "You have not selected any region!");
            return;
        }
        player.sendMessage(ChatColor.GREEN + "Successfully saved structure " + ChatColor.WHITE + name + ChatColor.GREEN + " in schematics folder.");
    }
}

