/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SupplySubCommand
extends AbstractCommand {
    public SupplySubCommand(@Nullable SchematicBuilderCommand parent) {
        super("supply", "Set whether the constructor needs to be supplied with materials before building", parent);
        this.permission = "schematicbuilder.supply";
    }

    @Override
    public List<String> getArguments(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("true");
        list.add("false");
        return list;
    }

    @Override
    public List<String> getUsages(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        list.add('/' + this.getFullCommand());
        list.add('/' + this.getFullCommand() + " true");
        list.add('/' + this.getFullCommand() + " false");
        return list;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        boolean requireMaterials;
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        NPC npc = builder.getNPC();
        if (args.size() == 0) {
            sender.sendMessage(ChatColor.GOLD + npc.getName() + " currently does" + (builder.isRequireMaterials() ? "" : " NOT") + " need to be supplied with materials.");
            return;
        }
        if (args.size() != 1) {
            this.sendUsage(sender);
            return;
        }
        try {
            requireMaterials = Boolean.parseBoolean(args.get(0));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + args.get(0) + " is not a valid boolean");
            return;
        }
        builder.setRequireMaterials(requireMaterials);
        sender.sendMessage(ChatColor.GOLD + npc.getName() + " now does" + (requireMaterials ? "" : " NOT") + " need to be supplied with materials.");
    }
}

