/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.commands;

import fr.weefle.constructor.commands.AbstractCommand;
import fr.weefle.constructor.commands.SchematicBuilderCommand;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeoutSubCommand
extends AbstractCommand {
    public TimeoutSubCommand(@Nullable SchematicBuilderCommand parent) {
        super("timeout", "Sets the maximum number of seconds between placed blocks", parent);
        this.permission = "schematicbuilder.timeout";
    }

    @Override
    public List<String> getUsages(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        list.add('/' + this.getFullCommand());
        list.add('/' + this.getFullCommand() + " <seconds>");
        return list;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull List<String> args) {
        double timeout;
        BuilderTrait builder = this.getSelectedBuilder(sender);
        if (builder == null) {
            return;
        }
        NPC npc = builder.getNPC();
        if (args.size() == 0) {
            sender.sendMessage(ChatColor.GOLD + npc.getName() + "'s Move Timeout is " + builder.getMoveTimeoutSeconds());
            return;
        }
        if (args.size() != 1) {
            this.sendUsage(sender);
            return;
        }
        try {
            timeout = Double.parseDouble(args.get(0));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + args.get(0) + " is not a valid number");
            return;
        }
        timeout = Math.min(Math.max(0.1, timeout), 2000000.0);
        builder.setMoveTimeoutSeconds(timeout);
        sender.sendMessage(ChatColor.GREEN + npc.getName() + " move timeout set to " + timeout + " s.");
    }
}

