/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.hooks.citizens;

import fr.weefle.constructor.Config;
import fr.weefle.constructor.SchematicBuilder;
import fr.weefle.constructor.hooks.citizens.BuilderTeleportStuckAction;
import fr.weefle.constructor.hooks.citizens.persistence.MaterialIntegerMapPersistenceLoader;
import fr.weefle.constructor.hooks.citizens.persistence.MaterialMapWrapper;
import fr.weefle.constructor.hooks.citizens.persistence.SchematicPersistenceLoader;
import fr.weefle.constructor.menu.menus.ParameterMenu;
import fr.weefle.constructor.nms.NMS;
import fr.weefle.constructor.schematic.Schematic;
import fr.weefle.constructor.schematic.blocks.DataBuildBlock;
import fr.weefle.constructor.schematic.blocks.EmptyBuildBlock;
import fr.weefle.constructor.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.TreeMap;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.dynmap.DynmapCommonAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TraitName(value="builder")
public class BuilderTrait
extends Trait
implements Toggleable {
    @Persist
    boolean toggled = true;
    @Persist(value="IgnoreAir")
    boolean ignoreAir = false;
    @Persist(value="IgnoreLiquid")
    boolean ignoreLiquids = false;
    @Persist(value="Excavate")
    boolean excavate = false;
    @Persist(value="Silent")
    boolean silent = false;
    @Persist(value="State")
    BuilderState state = BuilderState.IDLE;
    @Persist(value="PatternXY")
    BuildPatternXZ buildPatternXZ = BuildPatternXZ.SPIRAL;
    @Persist(value="HoldItems")
    boolean holdItems = SchematicBuilder.getInstance().config().isHoldItems();
    @Persist(value="RequireMaterials")
    boolean requireMaterials = SchematicBuilder.getInstance().config().isRequireMaterials();
    @Persist(value="MoveTimeoutSeconds")
    double moveTimeoutSeconds = 1.0;
    @Persist(value="YLayers")
    int buildYLayers = 1;
    @Persist(value="Schematic")
    @DelegatePersistence(value=SchematicPersistenceLoader.class)
    Schematic schematic = null;
    @Persist(value="Origin")
    Location origin = null;
    @Persist(value="ContinueLoc")
    Location continueLoc = null;
    @Persist(value="Materials")
    @DelegatePersistence(value=MaterialIntegerMapPersistenceLoader.class)
    MaterialMapWrapper materials = new MaterialMapWrapper(new TreeMap<Material, Integer>());
    @Persist(value="oncancel")
    String onCancel = null;
    @Persist(value="oncomplete")
    String onComplete = null;
    @Persist(value="onstart")
    String onStart = null;
    public Map<Material, Integer> ExcavateMaterials = new HashMap<Material, Integer>();
    public boolean GroupByLayer = true;
    public long startingcount = 1L;
    public Location start = null;
    private Queue<EmptyBuildBlock> queue = new LinkedList<EmptyBuildBlock>();
    private boolean clearingMarks = false;
    private final Map<Player, Long> sessions = new HashMap<Player, Long>();
    private Location mypos = null;
    private CommandSender sender = null;
    private EmptyBuildBlock next = null;
    private Block pending = null;
    private BukkitTask canceltaskid;
    private final Queue<EmptyBuildBlock> marks = new LinkedList<EmptyBuildBlock>();
    private final Queue<EmptyBuildBlock> _marks = new LinkedList<EmptyBuildBlock>();

    public BuilderTrait() {
        super("builder");
    }

    public boolean isIgnoreAir() {
        return this.ignoreAir;
    }

    public void setIgnoreAir(boolean ignoreAir) {
        this.ignoreAir = ignoreAir;
    }

    public boolean isIgnoreLiquids() {
        return this.ignoreLiquids;
    }

    public void setIgnoreLiquids(boolean ignoreLiquids) {
        this.ignoreLiquids = ignoreLiquids;
    }

    public boolean isExcavate() {
        return this.excavate;
    }

    public void setExcavate(boolean excavate) {
        this.excavate = excavate;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @NotNull
    public BuilderState getState() {
        return this.state;
    }

    @NotNull
    public BuildPatternXZ getBuildPatternXZ() {
        return this.buildPatternXZ;
    }

    public void setBuildPatternXZ(@NotNull BuildPatternXZ buildPatternXZ) {
        this.buildPatternXZ = buildPatternXZ;
    }

    public boolean isHoldItems() {
        return this.holdItems;
    }

    public void setHoldItems(boolean holdItems) {
        this.holdItems = holdItems;
    }

    public boolean isRequireMaterials() {
        return this.requireMaterials;
    }

    public void setRequireMaterials(boolean requireMaterials) {
        this.requireMaterials = requireMaterials;
    }

    public double getMoveTimeoutSeconds() {
        return this.moveTimeoutSeconds;
    }

    public void setMoveTimeoutSeconds(double moveTimeoutSeconds) {
        this.moveTimeoutSeconds = moveTimeoutSeconds;
    }

    public int getBuildYLayers() {
        return this.buildYLayers;
    }

    public void setBuildYLayers(int buildYLayers) {
        this.buildYLayers = buildYLayers;
    }

    @Nullable
    public Schematic getSchematic() {
        return this.schematic;
    }

    public void setSchematic(Schematic schematic) {
        this.schematic = schematic;
    }

    @NotNull
    public Location getOrigin() {
        return this.origin == null ? this.npc.getEntity().getLocation() : this.origin;
    }

    public void setOrigin(@Nullable Location origin) {
        this.origin = origin;
    }

    @Nullable
    public Location getContinueLoc() {
        return this.continueLoc == null ? null : this.continueLoc.clone();
    }

    public Map<Material, Integer> getStoredMaterials() {
        return Collections.unmodifiableMap(this.materials.getHandle());
    }

    @NotNull
    public Map<Material, Integer> getMissingMaterials() {
        TreeMap<Material, Integer> missingMaterials = new TreeMap<Material, Integer>();
        for (Map.Entry<Material, Integer> entry : this.schematic.getMaterials().entrySet()) {
            Material material = entry.getKey();
            int missing = entry.getValue() - this.materials.getHandle().getOrDefault(material, 0);
            if (missing <= 0) continue;
            missingMaterials.put(material, missing);
        }
        return missingMaterials;
    }

    @Nullable
    public String getOnCancel() {
        return this.onCancel;
    }

    public void setOnCancel(@Nullable String onCancel) {
        this.onCancel = onCancel;
    }

    @Nullable
    public String getOnComplete() {
        return this.onComplete;
    }

    public void setOnComplete(@Nullable String onComplete) {
        this.onComplete = onComplete;
    }

    @Nullable
    public String getOnStart() {
        return this.onStart;
    }

    public void setOnStart(@Nullable String onStart) {
        this.onStart = onStart;
    }

    public int getQueuedBlocks() {
        return this.queue.size();
    }

    public void onSpawn() {
        this.npc.getNavigator().getDefaultParameters().avoidWater(false);
        if (this.state == BuilderState.BUILDING || this.state == BuilderState.COLLECTING) {
            new BukkitRunnable(){

                public void run() {
                    BuilderTrait.this.state = BuilderState.IDLE;
                    BuilderTrait.this.TryBuild((CommandSender)Bukkit.getServer().getConsoleSender());
                }
            }.runTaskLater((Plugin)SchematicBuilder.getInstance(), 20L);
        } else {
            this.state = BuilderState.IDLE;
        }
    }

    public void handleRightClick(NPCRightClickEvent event) {
        ItemStack heldItem;
        Player player = event.getClicker();
        if (this.state == BuilderState.IDLE || this.state == BuilderState.BUILDING) {
            player.performCommand("npc select " + this.npc.getId());
            new ParameterMenu(event.getClicker(), this.npc).open();
        } else if (this.state == BuilderState.COLLECTING && (heldItem = player.getInventory().getItemInMainHand()).getType().isBlock() && heldItem.getType() != Material.AIR) {
            if (!player.hasPermission("schematicbuilder.donate")) {
                player.sendMessage(ChatColor.RED + "You do not have permission to donate");
                return;
            }
            Material material = heldItem.getType();
            Map<Material, Integer> requiredMaterials = this.schematic.getMaterials();
            int needed = requiredMaterials.getOrDefault(material, 0) - this.materials.getHandle().getOrDefault(material, 0);
            Config config = SchematicBuilder.getInstance().config();
            if (needed > 0) {
                int taking = Math.min(heldItem.getAmount(), needed);
                Long session = this.sessions.get(player);
                if (session != null && System.currentTimeMillis() < session + 5000L) {
                    ItemStack newItem;
                    if (heldItem.getAmount() - taking > 0) {
                        newItem = heldItem.clone();
                        newItem.setAmount(heldItem.getAmount() - taking);
                    } else {
                        newItem = new ItemStack(Material.AIR);
                    }
                    event.getClicker().getInventory().setItemInMainHand(newItem);
                    this.materials.getHandle().put(material, this.materials.getHandle().getOrDefault(material, 0) + taking);
                    player.sendMessage(SchematicBuilder.format(config.getSupplyTakenMessage(), this.npc, this.schematic, (CommandSender)player, heldItem.getType().name().toLowerCase(), taking + ""));
                    this.TryBuild(null);
                } else {
                    player.sendMessage(SchematicBuilder.format(config.getSupplyNeedMessage(), this.npc, this.schematic, (CommandSender)player, heldItem.getType().name().toLowerCase(), needed + ""));
                    this.sessions.put(player, System.currentTimeMillis());
                }
            } else {
                player.sendMessage(SchematicBuilder.format(config.getSupplyDontNeedMessage(), this.npc, this.schematic, (CommandSender)player, heldItem.getType().name().toLowerCase(), "0"));
            }
        }
    }

    public void onRemove() {
        this.state = BuilderState.IDLE;
    }

    public boolean toggle() {
        this.toggled = !this.toggled;
        return this.toggled;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public boolean TryBuild(CommandSender sender) {
        if (sender == null) {
            sender = this.sender;
        }
        this.sender = sender;
        if (this.requireMaterials) {
            int missing = 0;
            for (int value : this.getMissingMaterials().values()) {
                missing += value;
            }
            if (missing > 0) {
                if (!this.silent) {
                    sender.sendMessage(SchematicBuilder.format(SchematicBuilder.getInstance().config().getCollectingMessage(), this.npc, this.schematic, sender, this.schematic.getDisplayName(), String.valueOf(missing)));
                }
                this.state = BuilderState.COLLECTING;
                return true;
            }
        }
        return this.StartBuild(sender);
    }

    private boolean StartBuild(CommandSender player) {
        if (!this.npc.isSpawned()) {
            return false;
        }
        if (this.schematic == null) {
            return false;
        }
        if (this.state == BuilderState.BUILDING) {
            return false;
        }
        this.start = this.origin != null ? this.origin.clone() : (this.continueLoc != null ? this.continueLoc.clone() : this.npc.getEntity().getLocation().clone());
        this.queue = this.schematic.buildQueue(this);
        this.startingcount = this.queue.size();
        this.continueLoc = this.start.clone();
        this.mypos = this.npc.getEntity().getLocation().clone();
        this.state = BuilderState.BUILDING;
        if (!this.silent) {
            this.sender.sendMessage(SchematicBuilder.format(SchematicBuilder.getInstance().config().getStartedMessage(), this.npc, this.schematic, player, null, "0"));
        }
        if (this.onStart != null) {
            String resp = SchematicBuilder.runTask(this.onStart, this.npc);
            if (!this.silent) {
                if (resp == null) {
                    this.sender.sendMessage("Task " + this.onStart + " completed.");
                } else {
                    this.sender.sendMessage("Task " + this.onStart + " could not be run: " + resp);
                }
            }
        }
        SchematicBuilder.denizenAction(this.npc, "Build Start");
        SchematicBuilder.denizenAction(this.npc, "Build " + this.schematic.getDisplayName() + " Start");
        this.SetupNextBlock();
        return true;
    }

    public boolean StartMark(Material mat) {
        if (!this.npc.isSpawned()) {
            return false;
        }
        if (this.schematic == null) {
            return false;
        }
        if (this.state != BuilderState.IDLE) {
            return false;
        }
        this.onComplete = null;
        this.onCancel = null;
        this.onStart = null;
        this.mypos = this.npc.getEntity().getLocation().clone();
        this.continueLoc = this.origin == null ? this.npc.getEntity().getLocation().clone() : this.origin.clone();
        this.queue = this.schematic.createMarks(mat);
        this.state = BuilderState.MARKING;
        this.SetupNextBlock();
        return true;
    }

    public void SetupNextBlock() {
        if (this.marks.isEmpty()) {
            if (this.schematic == null) {
                this.CancelBuild();
                return;
            }
            this.next = this.queue.poll();
            if (this.next == null) {
                this.CompleteBuild();
                return;
            }
            this.pending = Objects.requireNonNull(this.continueLoc.getWorld()).getBlockAt(this.schematic.offset(this.continueLoc, this.next.X, this.next.Y, this.next.Z));
        } else {
            this.clearingMarks = true;
            this.next = this.marks.remove();
            this.pending = Objects.requireNonNull(this.continueLoc.getWorld()).getBlockAt(this.next.X, this.next.Y, this.next.Z);
        }
        if (this.next.getMat().equals(this.pending.getLocation().getBlock().getBlockData())) {
            this.SetupNextBlock();
        } else {
            if (this.npc.isSpawned() && (this.npc.getEntity() instanceof HumanEntity || this.npc.getEntity() instanceof Enderman) && this.holdItems) {
                if (this.npc.getEntity() instanceof HumanEntity && this.holdItems) {
                    ((HumanEntity)this.npc.getEntity()).getInventory().setItemInHand(new ItemStack(this.next.getMat().getMaterial()));
                } else if (this.npc.getEntity() instanceof Enderman && this.holdItems) {
                    ((Enderman)this.npc.getEntity()).setCarriedMaterial(new MaterialData(this.next.getMat().getMaterial()));
                }
            }
            new BukkitRunnable(){

                public void run() {
                    if (BuilderTrait.this.npc.isSpawned()) {
                        Location loc = BuilderTrait.this.findaspot(BuilderTrait.this.pending).add(0.5, 0.5, 0.5);
                        BuilderTrait.this.npc.getNavigator().setTarget(loc);
                        BuilderTrait.this.npc.getNavigator().getLocalParameters().stationaryTicks((int)(BuilderTrait.this.moveTimeoutSeconds * 20.0));
                        BuilderTrait.this.npc.getNavigator().getLocalParameters().stuckAction((StuckAction)BuilderTeleportStuckAction.INSTANCE);
                        BuilderTrait.this.npc.getNavigator().getPathStrategy().update();
                    }
                }
            }.runTask((Plugin)SchematicBuilder.getInstance());
            this.canceltaskid = new BukkitRunnable(){

                public void run() {
                    if (BuilderTrait.this.npc.isSpawned() && BuilderTrait.this.npc.getNavigator().isNavigating()) {
                        BuilderTrait.this.npc.getEntity().teleport(BuilderTrait.this.npc.getNavigator().getTargetAsLocation());
                        BuilderTrait.this.npc.getNavigator().getPathStrategy().update();
                        BuilderTrait.this.npc.getNavigator().cancelNavigation();
                    }
                }
            }.runTaskLater((Plugin)SchematicBuilder.getInstance(), (long)(this.moveTimeoutSeconds * 20.0) + 1L);
        }
    }

    public void CancelBuild() {
        if (this.onCancel != null) {
            SchematicBuilder.runTask(this.onCancel, this.npc);
        }
        SchematicBuilder.denizenAction(this.npc, "Build Cancel");
        if (this.schematic != null) {
            SchematicBuilder.denizenAction(this.npc, "Build " + this.schematic.getDisplayName() + " Cancel");
        }
        this.stop();
    }

    public void CompleteBuild() {
        if (this.sender == null) {
            this.sender = Bukkit.getServer().getConsoleSender();
        }
        if (this.state == BuilderState.BUILDING) {
            this.materials.getHandle().clear();
            if (!this.silent) {
                this.sender.sendMessage(SchematicBuilder.format(SchematicBuilder.getInstance().config().getCompleteMessage(), this.npc, this.schematic, this.sender, null, "0"));
            }
            if (this.onComplete != null) {
                String resp = SchematicBuilder.runTask(this.onComplete, this.npc);
                if (!this.silent) {
                    if (resp == null) {
                        this.sender.sendMessage("Task " + this.onComplete + " completed.");
                    } else {
                        this.sender.sendMessage("Task " + this.onComplete + " could not be run: " + resp);
                    }
                }
            }
            SchematicBuilder.denizenAction(this.npc, "Build Complete");
            SchematicBuilder.denizenAction(this.npc, "Build " + this.schematic.getDisplayName() + " Complete");
        }
        this.stop();
    }

    private void stop() {
        Plugin dynmap;
        boolean stop;
        boolean bl = stop = this.state == BuilderState.BUILDING;
        if (this.canceltaskid != null && !this.canceltaskid.isCancelled()) {
            this.canceltaskid.cancel();
        }
        if (this.state == BuilderState.MARKING) {
            this.state = BuilderState.IDLE;
            if (this.origin != null) {
                this.npc.getNavigator().setTarget(this.origin);
            } else {
                this.npc.getEntity().teleport(this.mypos);
            }
            this.marks.addAll(this._marks);
            this._marks.clear();
        } else {
            this.state = BuilderState.IDLE;
            if (stop && this.npc.isSpawned()) {
                if (this.npc.getNavigator().isNavigating()) {
                    this.npc.getNavigator().cancelNavigation();
                }
                this.npc.getNavigator().setTarget(this.mypos);
            }
        }
        if (this.npc.getEntity() instanceof HumanEntity && this.holdItems) {
            ((HumanEntity)this.npc.getEntity()).getInventory().setItemInHand(new ItemStack(Material.AIR));
        } else if (this.npc.getEntity() instanceof Enderman && this.holdItems) {
            ((Enderman)this.npc.getEntity()).setCarriedMaterial(new MaterialData(Material.AIR));
        }
        if (stop && (dynmap = Bukkit.getServer().getPluginManager().getPlugin("dynmap")) != null && dynmap.isEnabled()) {
            DynmapCommonAPI dyn = (DynmapCommonAPI)dynmap;
            Objects.requireNonNull(dyn).triggerRenderOfVolume(this.npc.getEntity().getWorld().getName(), this.continueLoc.getBlockX() - this.schematic.getWidth() / 2, this.continueLoc.getBlockY(), this.continueLoc.getBlockZ() - this.schematic.getLength() / 2, this.continueLoc.getBlockX() + this.schematic.getWidth() / 2, this.continueLoc.getBlockY() + this.schematic.getHeight() / 2, this.continueLoc.getBlockZ() + this.schematic.getLength() / 2);
        }
        this.sender = null;
        this.onComplete = null;
        this.onCancel = null;
        this.onStart = null;
        this.continueLoc = null;
    }

    public void PlaceNextBlock() throws IllegalArgumentException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (this.canceltaskid != null && !this.canceltaskid.isCancelled()) {
            this.canceltaskid.cancel();
        }
        BlockData bdata = this.next.getMat();
        if (this.state == BuilderState.MARKING && !this.clearingMarks) {
            this._marks.add(new DataBuildBlock(this.pending.getX(), this.pending.getY(), this.pending.getZ(), this.pending.getBlockData()));
        }
        this.pending.setBlockData(bdata);
        this.pending.getWorld().playEffect(this.pending.getLocation(), Effect.STEP_SOUND, (Object)this.pending.getType());
        NMS.getInstance().getChecker().check(this.next, this.pending);
        if (this.npc.getEntity() instanceof Player) {
            PlayerAnimation.ARM_SWING.play((Player)this.npc.getEntity(), 64);
        }
        if (this.marks.size() == 0) {
            this.clearingMarks = false;
        }
        this.SetupNextBlock();
    }

    private Location findaspot(Block base) {
        if (base == null) {
            return null;
        }
        for (int a = 3; a >= -5; --a) {
            if (Util.canStand(base.getRelative(0, a, -1))) {
                return base.getRelative(0, a - 1, -1).getLocation();
            }
            if (Util.canStand(base.getRelative(0, a, 1))) {
                return base.getRelative(0, a - 1, 1).getLocation();
            }
            if (Util.canStand(base.getRelative(1, a, 0))) {
                return base.getRelative(1, a - 1, 0).getLocation();
            }
            if (Util.canStand(base.getRelative(-1, a, 0))) {
                return base.getRelative(-1, a - 1, 0).getLocation();
            }
            if (Util.canStand(base.getRelative(-1, a, -1))) {
                return base.getRelative(-1, a - 1, -1).getLocation();
            }
            if (Util.canStand(base.getRelative(-1, a, 1))) {
                return base.getRelative(-1, a - 1, 1).getLocation();
            }
            if (Util.canStand(base.getRelative(1, a, 1))) {
                return base.getRelative(1, a - 1, 1).getLocation();
            }
            if (!Util.canStand(base.getRelative(1, a, -1))) continue;
            return base.getRelative(1, a - 1, -1).getLocation();
        }
        return base.getLocation();
    }

    public static enum BuilderState {
        IDLE,
        BUILDING,
        MARKING,
        COLLECTING;

    }

    public static enum BuildPatternXZ {
        SPIRAL,
        REVERSE_SPIRAL,
        LINEAR,
        REVERSE_LINEAR;

    }
}

