/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.hooks.citizens.persistence;

import fr.weefle.constructor.hooks.citizens.persistence.MaterialMapWrapper;
import java.util.Map;
import java.util.TreeMap;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Material;
import org.bukkit.configuration.MemorySection;

public class MaterialIntegerMapPersistenceLoader
implements Persister<MaterialMapWrapper> {
    public MaterialMapWrapper create(DataKey dataKey) {
        TreeMap<Material, Integer> map = new TreeMap<Material, Integer>();
        MaterialMapWrapper wrapper = new MaterialMapWrapper(map);
        MemorySection materials = (MemorySection)dataKey.getRaw("");
        if (materials == null) {
            return wrapper;
        }
        for (String key : materials.getKeys(false)) {
            Material material;
            try {
                material = Material.valueOf((String)key.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            int amount = map.getOrDefault(material, 0) + materials.getInt(key, 0);
            if (amount <= 0) continue;
            map.put(material, amount);
        }
        return wrapper;
    }

    public void save(MaterialMapWrapper map, DataKey dataKey) {
        Map<Material, Integer> handle = map.getHandle();
        if (handle.isEmpty()) {
            dataKey.removeKey("");
        } else {
            for (Map.Entry<Material, Integer> entry : handle.entrySet()) {
                int amount = entry.getValue();
                if (amount <= 0) continue;
                dataKey.setInt(entry.getKey().name(), amount);
            }
        }
    }
}

