/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.listener;

import fr.weefle.constructor.SchematicBuilder;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import fr.weefle.constructor.menu.Menu;
import fr.weefle.constructor.menu.Slot;
import fr.weefle.constructor.menu.menus.ExcavatedMenu;
import fr.weefle.constructor.menu.menus.MaterialsMenu;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mc.promcteam.engine.utils.ItemUT;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BuilderListener
implements Listener {
    public static Map<String, Integer> materials = new HashMap<String, Integer>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void place(BlockPlaceEvent event) {
        BuilderTrait inst = SchematicBuilder.getBuilder((Entity)event.getPlayer());
        if (inst != null) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder holder;
        Inventory otherInventory;
        Inventory inventory = event.getInventory();
        InventoryView view = event.getView();
        Inventory inventory2 = otherInventory = view.getTopInventory() == inventory ? view.getBottomInventory() : view.getTopInventory();
        if (otherInventory.getHolder() instanceof Menu && event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            event.setCancelled(true);
        }
        if ((holder = inventory.getHolder()) instanceof Menu) {
            event.setCancelled(true);
            Menu menu = (Menu)holder;
            Slot slot = menu.getSlot(event.getSlot());
            if (slot != null) {
                switch (event.getClick()) {
                    case LEFT: {
                        slot.onLeftClick();
                        break;
                    }
                    case SHIFT_LEFT: {
                        slot.onShiftLeftClick();
                        break;
                    }
                    case RIGHT: {
                        slot.onRightClick();
                        break;
                    }
                    case SHIFT_RIGHT: {
                        slot.onShiftRightClick();
                        break;
                    }
                    case NUMBER_KEY: {
                        slot.onNumberClick(event.getHotbarButton());
                        break;
                    }
                    case DOUBLE_CLICK: {
                        slot.onDoubleClick();
                        break;
                    }
                    case DROP: {
                        slot.onDrop();
                        break;
                    }
                    case CONTROL_DROP: {
                        slot.onControlDrop();
                        break;
                    }
                    case SWAP_OFFHAND: {
                        slot.onSwapOffhand();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Menu menu;
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Menu && !(menu = (Menu)holder).isOpening()) {
            new BukkitRunnable(){

                public void run() {
                    menu.onClose();
                }
            }.runTask((Plugin)SchematicBuilder.getInstance());
        }
    }

    @EventHandler
    public void clickedme2(NPCLeftClickEvent event) {
        Player player = event.getClicker();
        NPC npc = event.getNPC();
        BuilderTrait inst = SchematicBuilder.getBuilder(npc);
        if (inst != null) {
            if (inst.getState() == BuilderTrait.BuilderState.COLLECTING) {
                player.sendMessage(SchematicBuilder.format(SchematicBuilder.getInstance().config().getSupplyListMessage(), npc, inst.getSchematic(), (CommandSender)player, null, "0"));
                new MaterialsMenu(player, npc).open();
            } else if (inst.getState() == BuilderTrait.BuilderState.BUILDING && inst.isExcavate() && !inst.ExcavateMaterials.isEmpty()) {
                new ExcavatedMenu(player, npc).open();
            }
        }
    }

    @EventHandler
    public void clickedme(NPCRightClickEvent event) {
        NPC npc = event.getNPC();
        BuilderTrait inst = SchematicBuilder.getBuilder(npc);
        if (inst == null) {
            return;
        }
        inst.handleRightClick(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void NavCom(NavigationCompleteEvent event) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        BuilderTrait inst;
        NPC npc = null;
        for (NPC n : CitizensAPI.getNPCRegistry()) {
            if (n.getNavigator() != event.getNavigator()) continue;
            npc = n;
            break;
        }
        if ((inst = SchematicBuilder.getBuilder(npc)) == null) {
            return;
        }
        if (inst.getState() != BuilderTrait.BuilderState.IDLE) {
            inst.PlaceNextBlock();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void NavCan(NavigationCancelEvent event) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        BuilderTrait inst;
        NPC npc = null;
        for (NPC n : CitizensAPI.getNPCRegistry()) {
            if (n.getNavigator() != event.getNavigator()) continue;
            npc = n;
            break;
        }
        if ((inst = SchematicBuilder.getBuilder(npc)) == null) {
            return;
        }
        if (inst.getState() != BuilderTrait.BuilderState.IDLE) {
            inst.PlaceNextBlock();
        }
    }

    private static ItemStack getItem(String b64stringtexture) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        ItemUT.addSkullTexture((ItemStack)head, (String)b64stringtexture);
        ItemMeta headMeta = head.getItemMeta();
        if (headMeta != null) {
            headMeta.setDisplayName("Materials");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("Next Page");
            headMeta.setLore(lore);
            head.setItemMeta(headMeta);
        }
        return head;
    }

    private static <T> Field getField(Class<?> target, String name, Class<T> fieldType, int index) {
        for (Field field : target.getDeclaredFields()) {
            if (name != null && !field.getName().equals(name) || !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
            field.setAccessible(true);
            return field;
        }
        if (target.getSuperclass() != null) {
            return BuilderListener.getField(target.getSuperclass(), name, fieldType, index);
        }
        throw new IllegalArgumentException("Cannot find field with type " + fieldType);
    }

    public ItemStack getHead(String p) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        ItemMeta m = skull.getItemMeta();
        SkullMeta s = (SkullMeta)m;
        assert (s != null);
        s.setOwner(p);
        skull.setItemMeta((ItemMeta)s);
        return skull;
    }
}

