/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.menu;

import fr.weefle.constructor.menu.Menu;
import fr.weefle.constructor.menu.Slot;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FileExplorerMenu
extends Menu {
    protected final String root;
    protected final String path;
    private final Function<File, Slot> fileSlotFunction;

    public FileExplorerMenu(Player player, String root, int rows, String title, Function<File, Slot> fileSlotFunction) {
        super(player, rows, title);
        this.root = root + (root.endsWith(File.separator) || root.endsWith("/") ? "" : File.separator);
        this.path = "";
        this.fileSlotFunction = fileSlotFunction;
    }

    private FileExplorerMenu(Player player, String root, String path, int rows, String title, Function<File, Slot> fileSlotFunction) {
        super(player, rows, title);
        this.root = root;
        this.path = path + (path.endsWith(File.separator) || path.endsWith("/") ? "" : File.separator);
        this.fileSlotFunction = fileSlotFunction;
    }

    public String getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.root + this.path;
    }

    @Override
    public final void setContents() {
        int lastDirectory = 0;
        File[] fileArray = Objects.requireNonNull(new File(this.getFullPath()).listFiles());
        ArrayList<File> files = new ArrayList<File>(fileArray.length);
        for (File file : fileArray) {
            if (file.isDirectory()) {
                files.add(lastDirectory++, file);
                continue;
            }
            files.add(file);
        }
        int i = 0;
        for (File file : files) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            if (file.isDirectory()) {
                this.setSlot(i, new DirectorySlot(file.getName()));
                continue;
            }
            Slot slot = this.fileSlotFunction.apply(file);
            if (slot == null) continue;
            this.setSlot(i, slot);
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }

    public class DirectorySlot
    extends Slot {
        private final String name;

        public DirectorySlot(String name) {
            super(new ItemStack(Material.BOOK));
            this.name = name;
            ItemMeta meta = this.itemStack.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.RESET + name);
                this.itemStack.setItemMeta(meta);
            }
        }

        @Override
        public void onLeftClick() {
            FileExplorerMenu.this.openSubMenu(new FileExplorerMenu(FileExplorerMenu.this.player, FileExplorerMenu.this.root, FileExplorerMenu.this.path + this.name, FileExplorerMenu.this.inventory.getSize() / 9, FileExplorerMenu.this.title, FileExplorerMenu.this.fileSlotFunction));
        }
    }
}

