/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.nbt;

import fr.weefle.constructor.nbt.Tag;
import java.util.List;

public final class ByteArrayTag
extends Tag {
    private final byte[] value;

    public ByteArrayTag(byte[] value) {
        this.value = value;
    }

    public ByteArrayTag(List<Byte> value) {
        this.value = this.toArray(value);
    }

    public byte[] toArray(List<Byte> list) {
        byte[] array = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public int getTypeId() {
        return 7;
    }

    @Override
    public String asString() {
        StringBuilder stringbuilder = new StringBuilder("[B;");
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            if (i2 != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i2]).append('B');
        }
        return stringbuilder.append(']').toString();
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        for (byte b : this.value) {
            String hexDigits = Integer.toHexString(b).toUpperCase();
            if (hexDigits.length() == 1) {
                hex.append("0");
            }
            hex.append(hexDigits).append(" ");
        }
        return "TAG_Byte_Array(" + hex + ")";
    }
}

