/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.nbt;

import fr.weefle.constructor.nbt.Tag;
import java.util.List;

public final class IntArrayTag
extends Tag {
    private final int[] value;

    public IntArrayTag(int[] value) {
        this.value = value;
    }

    public IntArrayTag(List<Integer> value) {
        this.value = this.toArray(value);
    }

    public int[] getValue() {
        return this.value;
    }

    @Override
    public int getTypeId() {
        return 11;
    }

    public int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    @Override
    public String asString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            if (i2 != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.value[i2]);
        }
        return stringbuilder.append(']').toString();
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        for (int b : this.value) {
            String hexDigits = Integer.toHexString(b).toUpperCase();
            if (hexDigits.length() == 1) {
                hex.append("0");
            }
            hex.append(hexDigits).append(" ");
        }
        return "TAG_Int_Array(" + hex + ")";
    }
}

