/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.nbt;

import fr.weefle.constructor.nbt.IntArrayTag;
import fr.weefle.constructor.nbt.Tag;
import java.util.Arrays;
import java.util.List;

public class LongArrayTag
extends Tag {
    private final long[] value;

    public LongArrayTag(long[] value) {
        this.value = value;
    }

    public LongArrayTag(List<Long> value) {
        this.value = this.toArray(value);
    }

    public long[] getValue() {
        return this.value;
    }

    @Override
    public int getTypeId() {
        return 12;
    }

    public long[] toArray(List<Long> list) {
        long[] array = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public String toString() {
        StringBuilder longS = new StringBuilder();
        for (long b : this.value) {
            longS.append(b).append(" ");
        }
        return "TAG_Long_Array(" + longS.toString() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    public String asString() {
        StringBuilder var0 = new StringBuilder("[L;");
        for (int var1 = 0; var1 < this.value.length; ++var1) {
            if (var1 != 0) {
                var0.append(',');
            }
            var0.append(this.value[var1]).append('L');
        }
        return var0.append(']').toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IntArrayTag)) {
            return false;
        }
        LongArrayTag other = (LongArrayTag)obj;
        return Arrays.equals(this.value, other.value);
    }
}

