/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.nbt;

import fr.weefle.constructor.nbt.ByteArrayTag;
import fr.weefle.constructor.nbt.ByteTag;
import fr.weefle.constructor.nbt.CompoundTag;
import fr.weefle.constructor.nbt.DoubleTag;
import fr.weefle.constructor.nbt.EndTag;
import fr.weefle.constructor.nbt.FloatTag;
import fr.weefle.constructor.nbt.IntArrayTag;
import fr.weefle.constructor.nbt.IntTag;
import fr.weefle.constructor.nbt.ListTag;
import fr.weefle.constructor.nbt.LongArrayTag;
import fr.weefle.constructor.nbt.LongTag;
import fr.weefle.constructor.nbt.ShortTag;
import fr.weefle.constructor.nbt.StringTag;
import fr.weefle.constructor.nbt.Tag;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class NBTConstants {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final int TYPE_END = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_BYTE_ARRAY = 7;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_LIST = 9;
    public static final int TYPE_COMPOUND = 10;
    public static final int TYPE_INT_ARRAY = 11;
    public static final int TYPE_LONG_ARRAY = 12;

    private NBTConstants() {
    }

    public static Class<? extends Tag> getClassFromType(int id) {
        switch (id) {
            case 0: {
                return EndTag.class;
            }
            case 1: {
                return ByteTag.class;
            }
            case 2: {
                return ShortTag.class;
            }
            case 3: {
                return IntTag.class;
            }
            case 4: {
                return LongTag.class;
            }
            case 5: {
                return FloatTag.class;
            }
            case 6: {
                return DoubleTag.class;
            }
            case 7: {
                return ByteArrayTag.class;
            }
            case 8: {
                return StringTag.class;
            }
            case 9: {
                return ListTag.class;
            }
            case 10: {
                return CompoundTag.class;
            }
            case 11: {
                return IntArrayTag.class;
            }
            case 12: {
                return LongArrayTag.class;
            }
        }
        throw new IllegalArgumentException("Unknown tag type ID of " + id);
    }
}

