/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.nms;

import fr.weefle.constructor.api.StructureUtil;
import fr.weefle.constructor.nbt.ByteArrayTag;
import fr.weefle.constructor.nbt.ByteTag;
import fr.weefle.constructor.nbt.CompoundTag;
import fr.weefle.constructor.nbt.DoubleTag;
import fr.weefle.constructor.nbt.EndTag;
import fr.weefle.constructor.nbt.FloatTag;
import fr.weefle.constructor.nbt.IntArrayTag;
import fr.weefle.constructor.nbt.IntTag;
import fr.weefle.constructor.nbt.ListTag;
import fr.weefle.constructor.nbt.LongTag;
import fr.weefle.constructor.nbt.ShortTag;
import fr.weefle.constructor.nbt.StringTag;
import fr.weefle.constructor.nbt.Tag;
import fr.weefle.constructor.nms.TileChecker;
import fr.weefle.constructor.nms.providers.NMSProvider;
import fr.weefle.constructor.nms.providers.NMSProvider_1_16;
import fr.weefle.constructor.nms.providers.NMSProvider_1_17;
import fr.weefle.constructor.nms.providers.NMSProvider_1_18;
import fr.weefle.constructor.nms.providers.NMSProvider_1_19;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;

public class NMS {
    private static NMS instance;
    public String version;
    private NMSProvider nmsProvider;
    private fr.weefle.constructor.api.TileChecker checker;
    private StructureUtil structure;

    public boolean setInstance() {
        String[] packageArray = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        this.version = packageArray[packageArray.length - 1];
        Bukkit.getLogger().info("Your server is running version " + this.version);
        if (this.version.compareTo("v1_19_R1") >= 0) {
            this.nmsProvider = new NMSProvider_1_19();
        } else if (this.version.compareTo("v1_18_R1") >= 0) {
            this.nmsProvider = new NMSProvider_1_18();
        } else if (this.version.compareTo("v1_17_R1") >= 0) {
            this.nmsProvider = new NMSProvider_1_17();
        } else if (this.version.compareTo("v1_16_R1") >= 0) {
            this.nmsProvider = new NMSProvider_1_16(this.version);
        } else {
            return false;
        }
        this.setChecker(new TileChecker());
        instance = this;
        return true;
    }

    public static NMS getInstance() {
        return instance;
    }

    public NMSProvider getNMSProvider() {
        return this.nmsProvider;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public fr.weefle.constructor.api.TileChecker getChecker() {
        return this.checker;
    }

    public void setChecker(fr.weefle.constructor.api.TileChecker checker) {
        this.checker = checker;
    }

    public static Class<?> getNMSClass(String classname) {
        String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3] + ".";
        String name = "org.bukkit.craftbukkit." + version + classname;
        Class<?> nmsClass = null;
        try {
            nmsClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return nmsClass;
    }

    public static Object fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            Object tag = NMS.getInstance().getNMSProvider().newNBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                NMS.getInstance().getNMSProvider().nbtTagCompound_put(tag, (String)entry.getKey(), NMS.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return NMS.getInstance().getNMSProvider().nbtTagByte_valueOf(((ByteTag)foreign).getValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return NMS.getInstance().getNMSProvider().newNBTTagByteArray(((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return NMS.getInstance().getNMSProvider().nbtTagDouble_valueOf(((DoubleTag)foreign).getValue());
        }
        if (foreign instanceof FloatTag) {
            return NMS.getInstance().getNMSProvider().nbtTagFloat_valueOf(((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return NMS.getInstance().getNMSProvider().nbtTagInt_valueOf(((IntTag)foreign).getValue());
        }
        if (foreign instanceof IntArrayTag) {
            return NMS.getInstance().getNMSProvider().newNBTTagIntArray(((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            AbstractList<Object> tag = NMS.getInstance().getNMSProvider().newNBTTagList();
            ListTag foreignList = (ListTag)foreign;
            Iterator iterator = foreignList.getValue().iterator();
            while (iterator.hasNext()) {
                Tag t = (Tag)iterator.next();
                tag.add(NMS.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return NMS.getInstance().getNMSProvider().nbtTagLong_valueOf(((LongTag)foreign).getValue());
        }
        if (foreign instanceof ShortTag) {
            return NMS.getInstance().getNMSProvider().nbtTagShort_valueOf(((ShortTag)foreign).getValue());
        }
        if (foreign instanceof StringTag) {
            return NMS.getInstance().getNMSProvider().nbtTagString_valueOf(((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            throw new IllegalArgumentException("Cant make EndTag: " + foreign.getValue().toString());
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }
}

