/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.schematic;

import com.google.common.base.Preconditions;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import fr.weefle.constructor.nbt.CompoundTag;
import fr.weefle.constructor.nbt.ListTag;
import fr.weefle.constructor.nbt.NBTInputStream;
import fr.weefle.constructor.nbt.StringTag;
import fr.weefle.constructor.nbt.Tag;
import fr.weefle.constructor.nms.NMS;
import fr.weefle.constructor.schematic.Schematic;
import fr.weefle.constructor.schematic.blocks.DataBuildBlock;
import fr.weefle.constructor.schematic.blocks.EmptyBuildBlock;
import fr.weefle.constructor.schematic.blocks.EntityMap;
import fr.weefle.constructor.schematic.blocks.TileBuildBlock;
import fr.weefle.constructor.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawSchematic
extends Schematic {
    private int width;
    private int height;
    private int length;
    private Vector offset;
    private Vector absolutePosition;
    private EmptyBuildBlock[][][] blocks;
    private Map<Material, Integer> materials;

    public RawSchematic(Path path) {
        super(path);
        this.load(false);
    }

    @Override
    @Nullable
    public Vector getAbsolutePosition() {
        return this.absolutePosition == null ? null : this.absolutePosition.clone();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public EmptyBuildBlock getBlockAt(int x, int y, int z) {
        if (this.blocks == null) {
            throw new IllegalStateException("Schematic not loaded");
        }
        EmptyBuildBlock block = this.blocks[x][y][z];
        return block == null ? new EmptyBuildBlock(x, y, z) : block;
    }

    /*
     * WARNING - void declaration
     */
    private void load(boolean full) {
        Object data;
        File file = new File(this.getPath());
        if (this.getPath().endsWith(".schem")) {
            try (FileInputStream in = new FileInputStream(file);){
                data = NMS.getInstance().getNMSProvider().loadNBTFromInputStream(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.width = NMS.getInstance().getNMSProvider().nbtTagCompound_getShort(data, "Width");
            this.height = NMS.getInstance().getNMSProvider().nbtTagCompound_getShort(data, "Height");
            this.length = NMS.getInstance().getNMSProvider().nbtTagCompound_getShort(data, "Length");
            Object meta = NMS.getInstance().getNMSProvider().nbtTagCompound_getCompound(data, "Metadata");
            this.offset = meta == null ? new Vector() : new Vector(NMS.getInstance().getNMSProvider().nbtTagCompound_getInt(meta, "WEOffsetX"), NMS.getInstance().getNMSProvider().nbtTagCompound_getInt(meta, "WEOffsetY"), NMS.getInstance().getNMSProvider().nbtTagCompound_getInt(meta, "WEOffsetZ"));
            int[] offset = NMS.getInstance().getNMSProvider().nbtTagCompound_getIntArray(data, "Offset");
            if (offset.length == 3) {
                this.absolutePosition = new Vector(offset[0], offset[1], offset[2]);
            }
            if (!full) {
                return;
            }
            this.blocks = new EmptyBuildBlock[this.width][this.height][this.length];
            Object palette = NMS.getInstance().getNMSProvider().nbtTagCompound_getCompound(data, "Palette");
            HashMap<Integer, BlockData> blockStates = new HashMap<Integer, BlockData>();
            for (String rawState : NMS.getInstance().getNMSProvider().nbtTagCompound_getAllKeys(palette)) {
                int id = NMS.getInstance().getNMSProvider().nbtTagCompound_getInt(palette, rawState);
                try {
                    blockStates.put(id, Bukkit.createBlockData((String)rawState));
                }
                catch (IllegalArgumentException e) {
                    void var13_32;
                    String materialName = rawState.contains("[") ? rawState.substring(0, rawState.indexOf("[")).replace("minecraft:", "").toUpperCase() : rawState.replace("minecraft:", "").toUpperCase();
                    Material material = Material.getMaterial((String)materialName);
                    if (material == null) {
                        Material material2 = Material.getMaterial((String)materialName, (boolean)true);
                    }
                    if (var13_32 == null) continue;
                    blockStates.put(id, Bukkit.createBlockData((Material)var13_32));
                }
            }
            int version = NMS.getInstance().getNMSProvider().nbtTagCompound_getInt(data, "Version");
            AbstractList<Object> tileEntities = version > 1 ? NMS.getInstance().getNMSProvider().nbtTagCompound_getList(data, "BlockEntities", 10) : NMS.getInstance().getNMSProvider().nbtTagCompound_getList(data, "TileEntities", 10);
            HashMap tileEntitiesMap = new HashMap();
            Class<?> nbtTagCompound = NMS.getInstance().getNMSProvider().getNBTTagCompoundClass();
            for (Object e : tileEntities) {
                int[] pos;
                if (!nbtTagCompound.isAssignableFrom(e.getClass()) || (pos = NMS.getInstance().getNMSProvider().nbtTagCompound_getIntArray(e, "Pos")).length != 3) continue;
                tileEntitiesMap.put(new Vector(pos[0], pos[1], pos[2]), e);
            }
            byte[] blocks = NMS.getInstance().getNMSProvider().nbtTagCompound_getByteArray(data, "BlockData");
            boolean bl = false;
            int i = 0;
            while (i < blocks.length) {
                void var13_38;
                int value = 0;
                int varint_length = 0;
                while (true) {
                    value |= (blocks[i] & 0x7F) << varint_length++ * 7;
                    if (varint_length > 5) {
                        throw new RuntimeException("VarInt too big (probably corrupted data)");
                    }
                    if ((blocks[i] & 0x80) != 128) {
                        ++i;
                        break;
                    }
                    ++i;
                }
                void y = var13_38 / (this.width * this.length);
                void z = var13_38 % (this.width * this.length) / this.width;
                void x = var13_38 % (this.width * this.length) % this.width;
                Vector vector = new Vector((int)x, (int)y, (int)z);
                BlockData blockState = (BlockData)blockStates.get(value);
                Object tileEntity = tileEntitiesMap.remove(vector);
                this.blocks[x][y][z] = tileEntity == null ? new DataBuildBlock((int)x, (int)y, (int)z, blockState) : new TileBuildBlock((int)x, (int)y, (int)z, blockState, tileEntity);
                ++var13_38;
            }
        } else {
            ListTag paletteTags;
            try (NBTInputStream inputStream = new NBTInputStream(new FileInputStream(file), true);){
                data = (CompoundTag)inputStream.readNamedTag().getTag();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ListTag sizeTag = ((CompoundTag)data).getListTag("size");
            this.width = sizeTag.getInt(0);
            this.height = sizeTag.getInt(1);
            this.length = sizeTag.getInt(2);
            this.offset = null;
            if (!full) {
                return;
            }
            this.blocks = new EmptyBuildBlock[this.width][this.height][this.length];
            HashMap<Vector, BlockData> blocks = new HashMap<Vector, BlockData>();
            HashMap<Vector, Tag> tileEntities = new HashMap<Vector, Tag>();
            ListTag blockTags = ((CompoundTag)data).getListTag("blocks");
            if (((CompoundTag)data).containsKey("palette")) {
                paletteTags = ((CompoundTag)data).getListTag("palette");
                this.readBlocks(paletteTags, blockTags, blocks, tileEntities);
            } else {
                paletteTags = ((CompoundTag)data).getListTag("palettes");
                for (int i = 0; i < paletteTags.getValue().size(); ++i) {
                    this.readBlocks(paletteTags.getListTag(i), blockTags, blocks, tileEntities);
                }
            }
            for (Map.Entry entry : blocks.entrySet()) {
                Vector vector = (Vector)entry.getKey();
                int x = vector.getBlockX();
                int n = vector.getBlockY();
                int z = vector.getBlockZ();
                Tag tileEntity = (Tag)tileEntities.remove(vector);
                this.blocks[x][n][z] = tileEntity == null ? new DataBuildBlock(x, n, z, (BlockData)entry.getValue()) : new EntityMap(x, n, z, (BlockData)entry.getValue(), tileEntity);
            }
        }
        if (this.blocks != null) {
            TreeMap<Material, Integer> materials = new TreeMap<Material, Integer>();
            EmptyBuildBlock[][][] emptyBuildBlockArray = this.blocks;
            int n = emptyBuildBlockArray.length;
            for (int i = 0; i < n; ++i) {
                EmptyBuildBlock[][] plane;
                EmptyBuildBlock[][] emptyBuildBlockArray2 = plane = emptyBuildBlockArray[i];
                int n2 = emptyBuildBlockArray2.length;
                for (int j = 0; j < n2; ++j) {
                    EmptyBuildBlock[] row;
                    for (EmptyBuildBlock emptyBuildBlock : row = emptyBuildBlockArray2[j]) {
                        Material material = emptyBuildBlock.getMat().getMaterial();
                        if (material == Material.AIR || !material.isItem()) continue;
                        materials.put(material, materials.getOrDefault(material, 0) + 1);
                    }
                }
            }
            this.materials = Collections.unmodifiableMap(materials);
        }
    }

    private void unload() {
        this.blocks = null;
    }

    private void readBlocks(ListTag paletteTags, ListTag blockTags, Map<Vector, BlockData> blocks, Map<Vector, Tag> tileEntities) {
        for (int i = 0; i < blockTags.getValue().size(); ++i) {
            BlockData blockData;
            CompoundTag data;
            Tag tag = blockTags.getIfExists(i);
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag blockTag = (CompoundTag)tag;
            ListTag positionTags = blockTag.getListTag("pos");
            Vector position = new Vector(positionTags.getInt(0), positionTags.getInt(1), positionTags.getInt(2));
            tag = paletteTags.getIfExists(blockTag.getInt("state"));
            if (!(tag instanceof CompoundTag) || !(data = (CompoundTag)tag).containsKey("Name")) continue;
            String materialName = data.getString("Name").replace("minecraft:", "").toUpperCase();
            Material material = Material.getMaterial((String)materialName);
            if (material == null) {
                material = Material.getMaterial((String)materialName, (boolean)true);
            }
            if (material == null || material == Material.AIR) continue;
            if (data.containsKey("Properties")) {
                CompoundTag propertyTag = (CompoundTag)data.getValue().get("Properties");
                StringBuilder stringBuilder = new StringBuilder("[");
                Iterator entryIterator = propertyTag.getValue().entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    Tag value = (Tag)entry.getValue();
                    if (!(value instanceof StringTag)) continue;
                    stringBuilder.append((String)entry.getKey()).append('=').append(((StringTag)value).getValue());
                    if (!entryIterator.hasNext()) continue;
                    stringBuilder.append(',');
                }
                String blockDataString = stringBuilder.append(']').toString();
                blockData = material.createBlockData(blockDataString);
            } else {
                blockData = material.createBlockData();
            }
            if (blockTag.containsKey("nbt")) {
                tileEntities.put(position, (Tag)blockTag.getValue().get("nbt"));
            }
            blocks.put(position, blockData);
        }
    }

    @Override
    public Location offset(Location origin, int x, int y, int z, int emptyLayers) {
        return new Location(origin.getWorld(), (double)(origin.getBlockX() + x - this.offset.getBlockX()), (double)(origin.getBlockY() + y - this.offset.getBlockY() - emptyLayers), (double)(origin.getBlockZ() + z - this.offset.getBlockZ() + 1));
    }

    @Override
    @NotNull
    public Map<Material, Integer> getMaterials() {
        if (this.materials == null) {
            this.load(true);
            this.unload();
        }
        return this.materials;
    }

    @Override
    @NotNull
    public Queue<EmptyBuildBlock> buildQueue(BuilderTrait builder) {
        this.load(true);
        int yLayers = builder.getBuildYLayers();
        Preconditions.checkArgument((yLayers > 0 ? 1 : 0) != 0, (Object)("yLayers must be positive, but got " + yLayers));
        LinkedList<EmptyBuildBlock> queue = new LinkedList<EmptyBuildBlock>();
        int emptyLayers = 0;
        boolean ok = false;
        for (int tmpy = 0; tmpy < this.getHeight(); ++tmpy) {
            for (int tmpx = 0; tmpx < this.getWidth(); ++tmpx) {
                for (int tmpz = 0; tmpz < this.getLength(); ++tmpz) {
                    if (this.getBlockAt(tmpx, tmpy, tmpz).getMat().getMaterial() == Material.AIR) continue;
                    ok = true;
                }
            }
            if (ok) break;
            ++emptyLayers;
        }
        LinkedList<EmptyBuildBlock> exair = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> air = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> base = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> furniture = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> redstone = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> liquids = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> decors = new LinkedList<EmptyBuildBlock>();
        LinkedList<EmptyBuildBlock> buildQ = new LinkedList<EmptyBuildBlock>();
        Location origin = builder.getOrigin();
        for (int y = emptyLayers; y < this.getHeight(); y += yLayers) {
            List<EmptyBuildBlock> thisLayer;
            switch (builder.getBuildPatternXZ()) {
                case LINEAR: {
                    thisLayer = Util.LinearPrintLayer(y, yLayers, this.blocks, false);
                    break;
                }
                case REVERSE_LINEAR: {
                    thisLayer = Util.LinearPrintLayer(y, yLayers, this.blocks, true);
                    break;
                }
                case REVERSE_SPIRAL: {
                    thisLayer = Util.spiralPrintLayer(y, yLayers, this.blocks, true);
                    break;
                }
                default: {
                    thisLayer = Util.spiralPrintLayer(y, yLayers, this.blocks, false);
                }
            }
            block17: for (EmptyBuildBlock b : thisLayer) {
                Block pending = Objects.requireNonNull(origin.getWorld()).getBlockAt(this.offset(origin, b.X, b.Y, b.Z, emptyLayers));
                if (builder.isExcavate() && !pending.isEmpty()) {
                    Material material;
                    exair.add(new EmptyBuildBlock(b.X, b.Y, b.Z));
                    if (builder.ExcavateMaterials != null && (material = pending.getType()) != Material.AIR && material.isItem()) {
                        builder.ExcavateMaterials.put(material, builder.ExcavateMaterials.getOrDefault(material, 0) + 1);
                    }
                }
                if (!builder.isExcavate() && pending.getBlockData().getMaterial() == b.getMat().getMaterial()) continue;
                Material m = b.getMat().getMaterial();
                switch (m) {
                    case AIR: 
                    case CAVE_AIR: 
                    case VOID_AIR: {
                        if (builder.isIgnoreAir() || builder.isExcavate()) continue block17;
                        air.add(b);
                        continue block17;
                    }
                    case WATER: 
                    case LEGACY_STATIONARY_WATER: 
                    case LAVA: 
                    case LEGACY_STATIONARY_LAVA: {
                        if (builder.isIgnoreLiquids()) continue block17;
                        liquids.add(b);
                        continue block17;
                    }
                    case SAND: 
                    case GRAVEL: {
                        liquids.add(b);
                        continue block17;
                    }
                    case TORCH: 
                    case PAINTING: 
                    case SNOW: 
                    case LEGACY_WATER_LILY: 
                    case CACTUS: 
                    case LEGACY_SUGAR_CANE_BLOCK: 
                    case PUMPKIN: 
                    case PUMPKIN_STEM: 
                    case LEGACY_PORTAL: 
                    case LEGACY_CAKE_BLOCK: 
                    case VINE: 
                    case LEGACY_NETHER_WARTS: 
                    case LEGACY_LEAVES: 
                    case LEGACY_SAPLING: 
                    case DEAD_BUSH: 
                    case LEGACY_WEB: 
                    case LEGACY_LONG_GRASS: 
                    case LEGACY_RED_ROSE: 
                    case LEGACY_YELLOW_FLOWER: 
                    case RED_MUSHROOM: 
                    case BROWN_MUSHROOM: 
                    case FIRE: 
                    case LEGACY_CROPS: 
                    case LEGACY_MELON_BLOCK: 
                    case MELON_STEM: 
                    case LEGACY_ENDER_PORTAL: 
                    case JACK_O_LANTERN: 
                    case CARROT: 
                    case POTATO: 
                    case LEGACY_SKULL: 
                    case LEGACY_CARPET: {
                        decors.add(b);
                        continue block17;
                    }
                    case LEGACY_REDSTONE_TORCH_ON: 
                    case LEGACY_REDSTONE_TORCH_OFF: 
                    case REDSTONE_WIRE: 
                    case LEGACY_REDSTONE_LAMP_OFF: 
                    case LEGACY_REDSTONE_LAMP_ON: 
                    case LEVER: 
                    case TRIPWIRE_HOOK: 
                    case TRIPWIRE: 
                    case STONE_BUTTON: 
                    case LEGACY_DIODE_BLOCK_OFF: 
                    case LEGACY_DIODE_BLOCK_ON: 
                    case DAYLIGHT_DETECTOR: 
                    case LEGACY_DIODE: 
                    case LEGACY_RAILS: 
                    case LEGACY_REDSTONE_COMPARATOR_ON: 
                    case LEGACY_REDSTONE_COMPARATOR_OFF: 
                    case POWERED_RAIL: 
                    case DETECTOR_RAIL: 
                    case ACTIVATOR_RAIL: 
                    case LEGACY_PISTON_BASE: 
                    case LEGACY_PISTON_EXTENSION: 
                    case LEGACY_PISTON_MOVING_PIECE: 
                    case LEGACY_PISTON_STICKY_BASE: 
                    case TNT: 
                    case LEGACY_STONE_PLATE: 
                    case LEGACY_WOOD_PLATE: 
                    case GLOWSTONE: 
                    case HOPPER: 
                    case REDSTONE_BLOCK: 
                    case LEGACY_GOLD_PLATE: 
                    case LEGACY_IRON_PLATE: 
                    case LEGACY_WOOD_BUTTON: {
                        redstone.add(b);
                        continue block17;
                    }
                    case FURNACE: 
                    case LEGACY_BURNING_FURNACE: 
                    case BREWING_STAND: 
                    case CHEST: 
                    case JUKEBOX: 
                    case CAULDRON: 
                    case LEGACY_WOOD_DOOR: 
                    case LEGACY_WOODEN_DOOR: 
                    case IRON_DOOR: 
                    case LEGACY_TRAP_DOOR: 
                    case LEGACY_ENCHANTMENT_TABLE: 
                    case DISPENSER: 
                    case LEGACY_WORKBENCH: 
                    case LEGACY_SOIL: 
                    case LEGACY_SIGN_POST: 
                    case LEGACY_WALL_SIGN: 
                    case LADDER: 
                    case LEGACY_FENCE: 
                    case LEGACY_FENCE_GATE: 
                    case LEGACY_IRON_FENCE: 
                    case LEGACY_THIN_GLASS: 
                    case LEGACY_NETHER_FENCE: 
                    case DRAGON_EGG: 
                    case LEGACY_BED_BLOCK: 
                    case GLASS: 
                    case LEGACY_BIRCH_WOOD_STAIRS: 
                    case LEGACY_JUNGLE_WOOD_STAIRS: 
                    case LEGACY_WOOD_STAIRS: 
                    case LEGACY_SPRUCE_WOOD_STAIRS: 
                    case QUARTZ_STAIRS: 
                    case TRAPPED_CHEST: 
                    case ANVIL: 
                    case FLOWER_POT: {
                        furniture.add(b);
                        continue block17;
                    }
                }
                base.add(b);
            }
            thisLayer.clear();
            if (!builder.GroupByLayer) continue;
            buildQ.addAll(air);
            buildQ.addAll(base);
            buildQ.addAll(furniture);
            buildQ.addAll(redstone);
            buildQ.addAll(liquids);
            buildQ.addAll(decors);
            air.clear();
            base.clear();
            furniture.clear();
            redstone.clear();
            liquids.clear();
            decors.clear();
        }
        if (!builder.GroupByLayer) {
            buildQ.addAll(air);
            buildQ.addAll(base);
            buildQ.addAll(furniture);
            buildQ.addAll(redstone);
            buildQ.addAll(liquids);
            buildQ.addAll(decors);
            air.clear();
            base.clear();
            furniture.clear();
            redstone.clear();
            liquids.clear();
            decors.clear();
        }
        Collections.reverse((List)exair);
        queue.addAll(exair);
        queue.addAll(buildQ);
        exair.clear();
        buildQ.clear();
        this.unload();
        return queue;
    }
}

