/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.schematic;

import fr.weefle.constructor.SchematicBuilder;
import fr.weefle.constructor.hooks.citizens.BuilderTrait;
import fr.weefle.constructor.schematic.blocks.DataBuildBlock;
import fr.weefle.constructor.schematic.blocks.EmptyBuildBlock;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Schematic {
    protected final String path;
    protected String displayName;

    public Schematic(Path path) {
        this.path = path.toString();
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName == null ? new File(this.path).getName() : this.displayName;
    }

    @Nullable
    public abstract Vector getAbsolutePosition();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getLength();

    @NotNull
    public abstract EmptyBuildBlock getBlockAt(int var1, int var2, int var3);

    public abstract Location offset(Location var1, int var2, int var3, int var4, int var5);

    public Location offset(Location origin, int x, int y, int z) {
        return this.offset(origin, x, y, z, 0);
    }

    @NotNull
    public abstract Map<Material, Integer> getMaterials();

    public Queue<EmptyBuildBlock> createMarks(Material mat) {
        LinkedList<EmptyBuildBlock> queue = new LinkedList<EmptyBuildBlock>();
        queue.add(new DataBuildBlock(0, 0, 0, mat.createBlockData()));
        queue.add(new DataBuildBlock(this.getWidth() - 1, 0, 0, mat.createBlockData()));
        queue.add(new DataBuildBlock(0, 0, this.getLength() - 1, mat.createBlockData()));
        queue.add(new DataBuildBlock(this.getWidth() - 1, 0, this.getLength() - 1, mat.createBlockData()));
        return queue;
    }

    public void preview(final BuilderTrait builder, Player player, int ticks) {
        final Location origin = builder.getOrigin();
        final Queue<EmptyBuildBlock> queue = this.buildQueue(builder);
        for (EmptyBuildBlock block : queue) {
            player.sendBlockChange(this.offset(origin, block.X, block.Y, block.Z), block.getMat());
        }
        new BukkitRunnable(){

            public void run() {
                World world = builder.getNPC().getEntity().getWorld();
                for (EmptyBuildBlock block : queue) {
                    world.getBlockAt(Schematic.this.offset(origin, block.X, block.Y, block.Z)).getState().update();
                }
            }
        }.runTaskLater((Plugin)SchematicBuilder.getInstance(), (long)ticks);
    }

    @NotNull
    public abstract Queue<EmptyBuildBlock> buildQueue(BuilderTrait var1);

    public String getInfo() {
        return ChatColor.GREEN + "Path: " + ChatColor.WHITE + this.getPath() + ChatColor.GREEN + ", Name: " + ChatColor.WHITE + this.getDisplayName() + ChatColor.GREEN + ", Size: " + ChatColor.WHITE + this.getWidth() + " wide, " + this.getLength() + " long, " + this.getHeight() + " tall";
    }
}

