/*
 * Decompiled with CFR 0.152.
 */
package fr.weefle.constructor.util;

import fr.weefle.constructor.schematic.blocks.EmptyBuildBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class Util {
    public static String printMaterials(Map<Material, Integer> map) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<Material, Integer>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Material, Integer> i = it.next();
            if (i.getValue() <= 0) continue;
            sb.append(ChatColor.GREEN).append(i.getKey()).append(":").append(ChatColor.WHITE).append(i.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static List<EmptyBuildBlock> spiralPrintLayer(int starty, int ylayers, EmptyBuildBlock[][][] a, boolean reverse) {
        int k = 0;
        int l = 0;
        int m = a.length;
        int n = a[0].length;
        int o = a[0][0].length;
        ArrayList<EmptyBuildBlock> out = new ArrayList<EmptyBuildBlock>();
        while (k < m && l < o) {
            int y;
            int i;
            for (i = l; i < o; ++i) {
                if (reverse) {
                    for (y = starty; y < starty + ylayers; ++y) {
                        if (y >= n) continue;
                        out.add(a[k][y][i]);
                    }
                    continue;
                }
                for (y = starty + ylayers - 1; y >= starty; --y) {
                    if (y >= n) continue;
                    out.add(a[k][y][i]);
                }
            }
            for (i = ++k; i < m; ++i) {
                if (reverse) {
                    for (y = starty; y < starty + ylayers; ++y) {
                        if (y >= n) continue;
                        out.add(a[i][y][o - 1]);
                    }
                    continue;
                }
                for (y = starty + ylayers - 1; y >= starty; --y) {
                    if (y >= n) continue;
                    out.add(a[i][y][o - 1]);
                }
            }
            --o;
            if (k < m) {
                for (i = o - 1; i >= l; --i) {
                    if (reverse) {
                        for (y = starty; y < starty + ylayers; ++y) {
                            if (y >= n) continue;
                            out.add(a[m - 1][y][i]);
                        }
                        continue;
                    }
                    for (y = starty + ylayers - 1; y >= starty; --y) {
                        if (y >= n) continue;
                        out.add(a[m - 1][y][i]);
                    }
                }
                --m;
            }
            if (l >= o) continue;
            for (i = m - 1; i >= k; --i) {
                if (reverse) {
                    for (y = starty; y < starty + ylayers; ++y) {
                        if (y >= n) continue;
                        out.add(a[i][y][l]);
                    }
                    continue;
                }
                for (y = starty + ylayers - 1; y >= starty; --y) {
                    if (y >= n) continue;
                    out.add(a[i][y][l]);
                }
            }
            ++l;
        }
        if (!reverse) {
            Collections.reverse(out);
        }
        return out;
    }

    public static List<EmptyBuildBlock> LinearPrintLayer(int starty, int ylayers, EmptyBuildBlock[][][] a, boolean reverse) {
        int i = 0;
        int k = 0;
        int di = 1;
        int dk = 1;
        int m = a.length;
        int n = a[0].length;
        int o = a[0][0].length;
        ArrayList<EmptyBuildBlock> out = new ArrayList<EmptyBuildBlock>();
        while (true) {
            int y;
            if (!reverse) {
                for (y = starty; y < starty + ylayers; ++y) {
                    if (y >= n) continue;
                    out.add(a[i][y][k]);
                }
            } else {
                for (y = starty + ylayers - 1; y >= starty; --y) {
                    if (y >= n) continue;
                    out.add(a[i][y][k]);
                }
            }
            if ((i += di) < m && i >= 0) continue;
            i += (di *= -1);
            if (((k += dk) >= o || k < 0) && ++k >= o) break;
        }
        if (reverse) {
            Collections.reverse(out);
        }
        return out;
    }

    public static boolean canStand(Block base) {
        Block below = base.getRelative(0, -1, 0);
        if (!below.isEmpty() && below.getBlockData().getMaterial().isSolid()) {
            return base.isEmpty() || !base.getBlockData().getMaterial().isSolid();
        }
        return false;
    }
}

