/*
 * Decompiled with CFR 0.152.
 */
package com.protegrity.ap.java;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public enum PTYCharset {
    UTF8("UTF-8"),
    UTF16LE("UTF-16LE"),
    UTF16BE("UTF-16BE");


    private PTYCharset(String encoding) {
        if (encoding == null) {
            Charset.defaultCharset();
        } else {
            Charset.forName(encoding);
        }
    }

    public static Charset getPTYCharset(PTYCharset ... charset) {
        if (PTYCharset.validateInputCharset(charset)) {
            PTYCharset ptycharset = charset[0];
            if (ptycharset.equals((Object)UTF8)) {
                return StandardCharsets.UTF_8;
            }
            if (ptycharset.equals((Object)UTF16LE)) {
                return StandardCharsets.UTF_16LE;
            }
            if (ptycharset.equals((Object)UTF16BE)) {
                return StandardCharsets.UTF_16BE;
            }
            return null;
        }
        return null;
    }

    private static boolean validateInputCharset(PTYCharset ... charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        if (charset.length > 1) {
            throw new IllegalArgumentException("The number of charset sent should be 1");
        }
        if (charset.length == 1 && charset[0] == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        return charset.length == 1 && charset[0] != null;
    }
}

