/*
 * Decompiled with CFR 0.152.
 */
package com.protegrity.ap.java;

import com.protegrity.ap.java.AuthTokenResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class AuthTokenProvider {
    public static final String DEV_EDITION_HOST = "api.developer-edition.protegrity.com";

    /*
     * Enabled aggressive exception aggregation
     */
    public static AuthTokenResponse getJwtToken(String email, String password, String apiKey) {
        if (email == null || email.isEmpty() || password == null || password.isEmpty() || apiKey == null || apiKey.isEmpty()) {
            throw new IllegalArgumentException("Email, password, and API key must not be null or empty");
        }
        String baseUrl = "https://api.developer-edition.protegrity.com/auth/login";
        String payload = String.format("{\"email\":\"%s\", \"password\":\"%s\"}", email, password);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            AuthTokenResponse authTokenResponse;
            block15: {
                HttpPost httpPost = new HttpPost(baseUrl);
                httpPost.setHeader("Content-Type", "application/json");
                httpPost.setHeader("x-api-key", apiKey);
                httpPost.setEntity((HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    String jwtToken = AuthTokenProvider.extractJwtToken(responseBody);
                    authTokenResponse = new AuthTokenResponse(statusCode, jwtToken, apiKey, statusCode == 200 ? null : responseBody);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return authTokenResponse;
        }
        catch (IOException e) {
            return new AuthTokenResponse(500, null, apiKey, "Connection error: " + e.getMessage());
        }
    }

    private static String extractJwtToken(String responseBody) {
        try {
            JSONObject json = new JSONObject(responseBody);
            return json.optString("jwt_token", null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

