/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.github.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BranchProtectionRequiredPullRequestReview {
    @Nullable
    private Boolean dismissStaleReviews;
    @Nullable
    private List<String> dismissalRestrictions;
    @Nullable
    private List<String> pullRequestBypassers;
    @Nullable
    private Boolean requireCodeOwnerReviews;
    @Nullable
    private Boolean requireLastPushApproval;
    @Nullable
    private Integer requiredApprovingReviewCount;
    @Nullable
    private Boolean restrictDismissals;

    private BranchProtectionRequiredPullRequestReview() {
    }

    public Optional<Boolean> dismissStaleReviews() {
        return Optional.ofNullable(this.dismissStaleReviews);
    }

    public List<String> dismissalRestrictions() {
        return this.dismissalRestrictions == null ? List.of() : this.dismissalRestrictions;
    }

    public List<String> pullRequestBypassers() {
        return this.pullRequestBypassers == null ? List.of() : this.pullRequestBypassers;
    }

    public Optional<Boolean> requireCodeOwnerReviews() {
        return Optional.ofNullable(this.requireCodeOwnerReviews);
    }

    public Optional<Boolean> requireLastPushApproval() {
        return Optional.ofNullable(this.requireLastPushApproval);
    }

    public Optional<Integer> requiredApprovingReviewCount() {
        return Optional.ofNullable(this.requiredApprovingReviewCount);
    }

    public Optional<Boolean> restrictDismissals() {
        return Optional.ofNullable(this.restrictDismissals);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BranchProtectionRequiredPullRequestReview defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean dismissStaleReviews;
        @Nullable
        private List<String> dismissalRestrictions;
        @Nullable
        private List<String> pullRequestBypassers;
        @Nullable
        private Boolean requireCodeOwnerReviews;
        @Nullable
        private Boolean requireLastPushApproval;
        @Nullable
        private Integer requiredApprovingReviewCount;
        @Nullable
        private Boolean restrictDismissals;

        public Builder() {
        }

        public Builder(BranchProtectionRequiredPullRequestReview defaults) {
            Objects.requireNonNull(defaults);
            this.dismissStaleReviews = defaults.dismissStaleReviews;
            this.dismissalRestrictions = defaults.dismissalRestrictions;
            this.pullRequestBypassers = defaults.pullRequestBypassers;
            this.requireCodeOwnerReviews = defaults.requireCodeOwnerReviews;
            this.requireLastPushApproval = defaults.requireLastPushApproval;
            this.requiredApprovingReviewCount = defaults.requiredApprovingReviewCount;
            this.restrictDismissals = defaults.restrictDismissals;
        }

        @CustomType.Setter
        public Builder dismissStaleReviews(@Nullable Boolean dismissStaleReviews) {
            this.dismissStaleReviews = dismissStaleReviews;
            return this;
        }

        @CustomType.Setter
        public Builder dismissalRestrictions(@Nullable List<String> dismissalRestrictions) {
            this.dismissalRestrictions = dismissalRestrictions;
            return this;
        }

        public Builder dismissalRestrictions(String ... dismissalRestrictions) {
            return this.dismissalRestrictions(List.of(dismissalRestrictions));
        }

        @CustomType.Setter
        public Builder pullRequestBypassers(@Nullable List<String> pullRequestBypassers) {
            this.pullRequestBypassers = pullRequestBypassers;
            return this;
        }

        public Builder pullRequestBypassers(String ... pullRequestBypassers) {
            return this.pullRequestBypassers(List.of(pullRequestBypassers));
        }

        @CustomType.Setter
        public Builder requireCodeOwnerReviews(@Nullable Boolean requireCodeOwnerReviews) {
            this.requireCodeOwnerReviews = requireCodeOwnerReviews;
            return this;
        }

        @CustomType.Setter
        public Builder requireLastPushApproval(@Nullable Boolean requireLastPushApproval) {
            this.requireLastPushApproval = requireLastPushApproval;
            return this;
        }

        @CustomType.Setter
        public Builder requiredApprovingReviewCount(@Nullable Integer requiredApprovingReviewCount) {
            this.requiredApprovingReviewCount = requiredApprovingReviewCount;
            return this;
        }

        @CustomType.Setter
        public Builder restrictDismissals(@Nullable Boolean restrictDismissals) {
            this.restrictDismissals = restrictDismissals;
            return this;
        }

        public BranchProtectionRequiredPullRequestReview build() {
            BranchProtectionRequiredPullRequestReview _resultValue = new BranchProtectionRequiredPullRequestReview();
            _resultValue.dismissStaleReviews = this.dismissStaleReviews;
            _resultValue.dismissalRestrictions = this.dismissalRestrictions;
            _resultValue.pullRequestBypassers = this.pullRequestBypassers;
            _resultValue.requireCodeOwnerReviews = this.requireCodeOwnerReviews;
            _resultValue.requireLastPushApproval = this.requireLastPushApproval;
            _resultValue.requiredApprovingReviewCount = this.requiredApprovingReviewCount;
            _resultValue.restrictDismissals = this.restrictDismissals;
            return _resultValue;
        }
    }
}

