/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.github.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RepositoryTemplate {
    @Nullable
    private Boolean includeAllBranches;
    private String owner;
    private String repository;

    private RepositoryTemplate() {
    }

    public Optional<Boolean> includeAllBranches() {
        return Optional.ofNullable(this.includeAllBranches);
    }

    public String owner() {
        return this.owner;
    }

    public String repository() {
        return this.repository;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RepositoryTemplate defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean includeAllBranches;
        private String owner;
        private String repository;

        public Builder() {
        }

        public Builder(RepositoryTemplate defaults) {
            Objects.requireNonNull(defaults);
            this.includeAllBranches = defaults.includeAllBranches;
            this.owner = defaults.owner;
            this.repository = defaults.repository;
        }

        @CustomType.Setter
        public Builder includeAllBranches(@Nullable Boolean includeAllBranches) {
            this.includeAllBranches = includeAllBranches;
            return this;
        }

        @CustomType.Setter
        public Builder owner(String owner) {
            if (owner == null) {
                throw new MissingRequiredPropertyException("RepositoryTemplate", "owner");
            }
            this.owner = owner;
            return this;
        }

        @CustomType.Setter
        public Builder repository(String repository) {
            if (repository == null) {
                throw new MissingRequiredPropertyException("RepositoryTemplate", "repository");
            }
            this.repository = repository;
            return this;
        }

        public RepositoryTemplate build() {
            RepositoryTemplate _resultValue = new RepositoryTemplate();
            _resultValue.includeAllBranches = this.includeAllBranches;
            _resultValue.owner = this.owner;
            _resultValue.repository = this.repository;
            return _resultValue;
        }
    }
}

