/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.github.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.github.outputs.GetTreeEntry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetTreeResult {
    private List<GetTreeEntry> entries;
    private String id;
    @Nullable
    private Boolean recursive;
    private String repository;
    private String treeSha;

    private GetTreeResult() {
    }

    public List<GetTreeEntry> entries() {
        return this.entries;
    }

    public String id() {
        return this.id;
    }

    public Optional<Boolean> recursive() {
        return Optional.ofNullable(this.recursive);
    }

    public String repository() {
        return this.repository;
    }

    public String treeSha() {
        return this.treeSha;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetTreeResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<GetTreeEntry> entries;
        private String id;
        @Nullable
        private Boolean recursive;
        private String repository;
        private String treeSha;

        public Builder() {
        }

        public Builder(GetTreeResult defaults) {
            Objects.requireNonNull(defaults);
            this.entries = defaults.entries;
            this.id = defaults.id;
            this.recursive = defaults.recursive;
            this.repository = defaults.repository;
            this.treeSha = defaults.treeSha;
        }

        @CustomType.Setter
        public Builder entries(List<GetTreeEntry> entries) {
            if (entries == null) {
                throw new MissingRequiredPropertyException("GetTreeResult", "entries");
            }
            this.entries = entries;
            return this;
        }

        public Builder entries(GetTreeEntry ... entries) {
            return this.entries(List.of(entries));
        }

        @CustomType.Setter
        public Builder id(String id) {
            if (id == null) {
                throw new MissingRequiredPropertyException("GetTreeResult", "id");
            }
            this.id = id;
            return this;
        }

        @CustomType.Setter
        public Builder recursive(@Nullable Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @CustomType.Setter
        public Builder repository(String repository) {
            if (repository == null) {
                throw new MissingRequiredPropertyException("GetTreeResult", "repository");
            }
            this.repository = repository;
            return this;
        }

        @CustomType.Setter
        public Builder treeSha(String treeSha) {
            if (treeSha == null) {
                throw new MissingRequiredPropertyException("GetTreeResult", "treeSha");
            }
            this.treeSha = treeSha;
            return this;
        }

        public GetTreeResult build() {
            GetTreeResult _resultValue = new GetTreeResult();
            _resultValue.entries = this.entries;
            _resultValue.id = this.id;
            _resultValue.recursive = this.recursive;
            _resultValue.repository = this.repository;
            _resultValue.treeSha = this.treeSha;
            return _resultValue;
        }
    }
}

