/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.github.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RepositoryWebhookConfiguration {
    @Nullable
    private String contentType;
    @Nullable
    private Boolean insecureSsl;
    @Nullable
    private String secret;
    private String url;

    private RepositoryWebhookConfiguration() {
    }

    public Optional<String> contentType() {
        return Optional.ofNullable(this.contentType);
    }

    public Optional<Boolean> insecureSsl() {
        return Optional.ofNullable(this.insecureSsl);
    }

    public Optional<String> secret() {
        return Optional.ofNullable(this.secret);
    }

    public String url() {
        return this.url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RepositoryWebhookConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String contentType;
        @Nullable
        private Boolean insecureSsl;
        @Nullable
        private String secret;
        private String url;

        public Builder() {
        }

        public Builder(RepositoryWebhookConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.contentType = defaults.contentType;
            this.insecureSsl = defaults.insecureSsl;
            this.secret = defaults.secret;
            this.url = defaults.url;
        }

        @CustomType.Setter
        public Builder contentType(@Nullable String contentType) {
            this.contentType = contentType;
            return this;
        }

        @CustomType.Setter
        public Builder insecureSsl(@Nullable Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
            return this;
        }

        @CustomType.Setter
        public Builder secret(@Nullable String secret) {
            this.secret = secret;
            return this;
        }

        @CustomType.Setter
        public Builder url(String url) {
            if (url == null) {
                throw new MissingRequiredPropertyException("RepositoryWebhookConfiguration", "url");
            }
            this.url = url;
            return this;
        }

        public RepositoryWebhookConfiguration build() {
            RepositoryWebhookConfiguration _resultValue = new RepositoryWebhookConfiguration();
            _resultValue.contentType = this.contentType;
            _resultValue.insecureSsl = this.insecureSsl;
            _resultValue.secret = this.secret;
            _resultValue.url = this.url;
            return _resultValue;
        }
    }
}

