/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper;

import com.qualifiedcactus.sqlObjectMapper.SqlObjectMapperException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0002JF\u0010\u001a\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/NamedParameterQuery;", "", "npSqlQuery", "", "(Ljava/lang/String;)V", "parameterIndexes", "", "", "", "getParameterIndexes", "()Ljava/util/Map;", "parameterStarter", "", "getParameterStarter", "()C", "translatedQuery", "getTranslatedQuery", "()Ljava/lang/String;", "parseOther", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "curIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "input", "parseParam", "paramIndexes", "", "", "currentParameterIndex", "sqlObjectMapper"})
public final class NamedParameterQuery {
    private final char parameterStarter;
    @NotNull
    private final String translatedQuery;
    @NotNull
    private final Map<String, List<Integer>> parameterIndexes;

    public NamedParameterQuery(@NotNull String npSqlQuery) {
        Intrinsics.checkNotNullParameter((Object)npSqlQuery, (String)"npSqlQuery");
        this.parameterStarter = (char)58;
        StringBuilder translatedQueryBuilder = new StringBuilder(npSqlQuery.length());
        HashMap paramIndexes = new HashMap();
        AtomicInteger i = new AtomicInteger(0);
        AtomicInteger curParameterIndex = new AtomicInteger(1);
        while (i.get() < npSqlQuery.length()) {
            if (npSqlQuery.charAt(i.get()) == '?') {
                throw new SqlObjectMapperException("Character '?' is not allowed");
            }
            if (npSqlQuery.charAt(i.get()) == this.parameterStarter) {
                this.parseParam(translatedQueryBuilder, i, npSqlQuery, paramIndexes, curParameterIndex);
                continue;
            }
            this.parseOther(translatedQueryBuilder, i, npSqlQuery);
        }
        String string = translatedQueryBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translatedQueryBuilder.toString()");
        this.translatedQuery = string;
        this.parameterIndexes = paramIndexes;
    }

    public final char getParameterStarter() {
        return this.parameterStarter;
    }

    @NotNull
    public final String getTranslatedQuery() {
        return this.translatedQuery;
    }

    @NotNull
    public final Map<String, List<Integer>> getParameterIndexes() {
        return this.parameterIndexes;
    }

    private final void parseParam(StringBuilder out, AtomicInteger curIndex, String input, Map<String, List<Integer>> paramIndexes, AtomicInteger currentParameterIndex) {
        boolean validParameterStart;
        boolean bl;
        boolean bl2 = bl = input.charAt(curIndex.get()) == this.parameterStarter;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        curIndex.incrementAndGet();
        boolean bl3 = validParameterStart = curIndex.get() < input.length() && Character.isJavaIdentifierStart(input.charAt(curIndex.get()));
        if (!validParameterStart) {
            throw new SqlObjectMapperException("Invalid parameter's starting character or parameter is empty");
        }
        StringBuilder paramNameBuilder = new StringBuilder();
        paramNameBuilder.append(Character.toUpperCase(input.charAt(curIndex.getAndIncrement())));
        while (curIndex.get() < input.length() && Character.isJavaIdentifierPart(input.charAt(curIndex.get()))) {
            paramNameBuilder.append(Character.toUpperCase(input.charAt(curIndex.getAndIncrement())));
        }
        String string = paramNameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"paramNameBuilder.toString()");
        String paramName = string;
        List indexList = paramIndexes.get(paramName);
        if (indexList != null) {
            indexList.add(currentParameterIndex.getAndIncrement());
        } else {
            indexList = new ArrayList();
            ((ArrayList)indexList).add(currentParameterIndex.getAndIncrement());
            paramIndexes.put(paramName, indexList);
        }
        out.append('?');
    }

    private final void parseOther(StringBuilder out, AtomicInteger curIndex, String input) {
        while (curIndex.get() < input.length() && input.charAt(curIndex.get()) != this.parameterStarter) {
            out.append(input.charAt(curIndex.getAndIncrement()));
        }
    }
}

