/*
 * Decompiled with CFR 0.152.
 */
package com.qualifiedcactus.sqlObjectMapper;

import com.qualifiedcactus.sqlObjectMapper.MappingProvider;
import com.qualifiedcactus.sqlObjectMapper.NpCallableStatement;
import com.qualifiedcactus.sqlObjectMapper.NpPreparedStatement;
import com.qualifiedcactus.sqlObjectMapper.NpStatements;
import com.qualifiedcactus.sqlObjectMapper.toParam.JdbcObjectCreator;
import com.qualifiedcactus.sqlObjectMapper.toParam.ParamClassMapping;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fj\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/qualifiedcactus/sqlObjectMapper/NpSqlStringBuilder;", "", "connection", "Ljava/sql/Connection;", "startingString", "", "(Ljava/sql/Connection;Ljava/lang/String;)V", "getConnection", "()Ljava/sql/Connection;", "jdbcObjectCreator", "Lcom/qualifiedcactus/sqlObjectMapper/toParam/JdbcObjectCreator;", "parameterValues", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addParameter", "paramName", "paramValue", "addParametersByDto", "dto", "append", "s", "toNpCallableStatement", "Lcom/qualifiedcactus/sqlObjectMapper/NpCallableStatement;", "toNpPreparedStatement", "Lcom/qualifiedcactus/sqlObjectMapper/NpPreparedStatement;", "toQueryString", "sqlObjectMapper"})
public final class NpSqlStringBuilder {
    @NotNull
    private final Connection connection;
    @NotNull
    private final String startingString;
    @NotNull
    private final JdbcObjectCreator jdbcObjectCreator;
    @NotNull
    private final StringBuilder stringBuilder;
    @NotNull
    private final HashMap<String, Object> parameterValues;

    @JvmOverloads
    public NpSqlStringBuilder(@NotNull Connection connection, @NotNull String startingString) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)startingString, (String)"startingString");
        this.connection = connection;
        this.startingString = startingString;
        this.jdbcObjectCreator = new JdbcObjectCreator(this.connection);
        this.stringBuilder = new StringBuilder(this.startingString);
        this.parameterValues = new HashMap();
    }

    public /* synthetic */ NpSqlStringBuilder(Connection connection, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(connection, string);
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final NpSqlStringBuilder append(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.stringBuilder.append(s);
        return this;
    }

    @NotNull
    public final String toQueryString() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    @NotNull
    public final NpSqlStringBuilder addParameter(@NotNull String paramName, @Nullable Object paramValue) {
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Map map = this.parameterValues;
        String string = paramName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        map.put(string, paramValue);
        return this;
    }

    @NotNull
    public final NpSqlStringBuilder addParametersByDto(@NotNull Object dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        ParamClassMapping mapping = MappingProvider.INSTANCE.mapParamClass(Reflection.getOrCreateKotlinClass(dto.getClass()));
        Map<String, ParamClassMapping.Parameter> $this$forEach$iv = mapping.getValueExtractors();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ParamClassMapping.Parameter>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ParamClassMapping.Parameter> element$iv;
            Map.Entry<String, ParamClassMapping.Parameter> entry = element$iv = iterator.next();
            boolean bl = false;
            String paramName = entry.getKey();
            ParamClassMapping.Parameter paramInfo = entry.getValue();
            ((Map)this.parameterValues).put(paramName, paramInfo.getConverter().convert(paramInfo.getGetter().invoke(dto), this.jdbcObjectCreator));
        }
        return this;
    }

    @NotNull
    public final NpPreparedStatement toNpPreparedStatement() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        NpPreparedStatement npStatement = NpStatements.prepareNpStatement(this.connection, string);
        Map $this$forEach$iv = this.parameterValues;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String paramName = (String)entry.getKey();
            Object paramValue = entry.getValue();
            npStatement.setParameterUpperCased$sqlObjectMapper(paramName, paramValue);
        }
        return npStatement;
    }

    @NotNull
    public final NpCallableStatement toNpCallableStatement() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        NpCallableStatement npStatement = NpStatements.prepareNpCall(this.connection, string);
        Map $this$forEach$iv = this.parameterValues;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String paramName = (String)entry.getKey();
            Object paramValue = entry.getValue();
            npStatement.setParameterUpperCased$sqlObjectMapper(paramName, paramValue);
        }
        return npStatement;
    }

    @JvmOverloads
    public NpSqlStringBuilder(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this(connection, null, 2, null);
    }
}

